<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use DateTime;
use DateInterval;



class MyApp extends Model {

    const SEXE = ['M'=>'Masculin','F' => 'Feminin'];

    const CIVILITE = ['Mr'=>'Monsieur','Mme' => 'Madame'];

    const JOURS=["LUNDI","MARDI","MERCREDI","JEUDI","VENDREDI","SAMEDI"];

    const MOIS=["JANVIER","FEVRIER","MARS","AVRIL","MAI","JUIN","JUILLET","AOUT","SEPTEMBRE","OCTOBRE","NOVEMBRE","DECEMBRE"];
    const MOIS_NUM=['01'=>'Janvier', '02'=>'Février', '03'=>'Mars', '04'=>'Avril','05'=>'Mai', '06'=>'Juin', '07'=>'Juillet', '08'=>'Août', '09'=>'Septembre','10'=>'Octobre', '11'=>'Novembre', '12'=>'Décembre'];
    const MOIS_COURT_LONG=['jan'=>'Janvier','fev'=>'Février','mar'=>'Mars','avr'=>'Avril','mai'=>'Mai','jun'=>'Juin','jui'=>'Juillet','aou'=>'Août','sep'=>'Septembre','oct'=>'Octobre','nov'=>'Novembre','dec'=>'Décembre'];
    const MOIS_NUM_TEXTE_LONG=["01"=>"de Janvier","02"=>"de Février","03"=>"de Mars","04"=>"d'Avril","05"=>"de Mai","06"=>"de Juin","07"=>"de Juillet","08"=>"d'Août","09"=>"de Septembre","10"=>"d'Octobre","11"=>"de Novembre","12"=>"de Décembre"];
    
    const ROYAUMES=["UVEA"=>"UVEA","ALO"=>"ALO","SIGAVE"=>"SIGAVE"];
    const ILES=['W' => 'Wallis', 'F' => 'Futuna', 'A' => 'Autre'];

    const TYPES_AIDES=['AAE' => "Aide à l'enfant", 'PAN' => "Prime à la naissance",
        'CSR' => "Complément Social de Retraite",'FSO' => "Filet Social"];

    const TYPES_AIDES_COURT=['AAE' => "Aide à l'enfant", 'PAN' => "Prime à la naissance",
        'CSR' => "CSR",'FSO' => "Filet Social"];
    const PREFIXE_AIDES=['AAE' => "de l'", 'PAN' => "de la ",'CSR' => "de la ",'FSO' => "du "];
    const COLOR_AIDES=['AAE' => "success", 'PAN' => "warning",'CSR' => "info",'FSO' => "purple"];
    const ICON_AIDES=['AAE' => "fa-hands-holding-child", 'PAN' => "fa-baby-carriage"
                        ,'CSR' => "fa-person-cane",'FSO' => "fa-handshake-simple"];
    /*                   
    const TYPES_AIDES=['APA' => 'Allocation Personnes Agées', 'AAE' => "Aide à l'enfant", 'PAN' => "Prime à la naissance",
                        'AGD' => 'Allocation Grande dépendance','ALH' => 'Allocation Handicap','ALH' => 'Allocation Handicap'
                        ,'ALE' => "Allocation à l'eau",'ASO' => "Accompagnement Social",'PEN' => "Protection de l'enfance"];
    */
    const BENEF_ROLES=['BEN' => "Bénéficiaire d'aide", 'MEM' => "Membre du foyer d'un bénéficiaire", 
        'ENF' => "Enfant d'un bénéficiaire", 'MEH' => "Membre Hors foyer d'un bénéficiaire",'AID' => "Aidant" ];

    //pour STATS
    const AGE_ENFANT_TRANCHES=['0-3','3-6','6-9','9-12','12-15','15-18','18-21'];
    const AGE_ALLOCATAIRES_TRANCHES=['0-18'=>'Mineur','18-30'=>'18/30','30-60'=>'30/60','60-99'=>'+60'];
    const CSR_AGE_TRANCHES=['0-70'=>'60/70','70-80'=>'70/80','80-999'=>'+480'];
    const CSR_MONTANTS_RETRAITE=['0-42000'=>'<42000','42001-50000'=>'42001-50000'
        ,'50001-60000'=>'50001-60000','60001-70000'=>'60001-70000','70001-80000'=>'70001-80000'
        ,'80001-90000'=>'80001-90000','90000-9999999'=>'>90001'];

    //7
    const FOYER_ROLES=['ENF'=>'Enfant','PEN'=>'Petit enfant','NIE'=>'Neveux-nièce','AUT'=>'Autre'];  
    
    const MODE_VERSEMENT=['VIR'=>'Virement bancaire','NUM'=>'Numéraire'];  

    const COMPTE_IBAN=["titulaire","IBAN_pays","IBAN_cle","IBAN_banque","IBAN_guichet","IBAN_compte","IBAN_clerib"];
    const FORMAT_COMPTE_IBAN=["IBAN_pays"=>"2","IBAN_cle"=>"2","IBAN_banque"=>"5","IBAN_guichet"=>"5","IBAN_compte"=>"11","IBAN_clerib"=>"2"];
    const SIZE_IBAN=27;

    const SITAS_ADRESSE="SITAS - BP 385 MATA UTU - 98600 WALLIS - TEL : 72 01 67";

    const DROITS_OUVERTURE=['ATT'=>'Droits non ouverts','FER'=>'Droits fermés','OUV'=>'Droits ouverts','NDF'=>'Dates non définies'];  
    //Ages filet social
    const AGE_MAX_CERTIF=21;
    const FSO_AGE_MIN=18;
    const FSO_AGE_TRANCHE=60;

    /* ************************** */
    /*           COOKIE            */
    /* ************************** */

    /**
     * renvoi la valeur Session et enregistre
     */
    static public function putSessionValue($name_variable,$value="")
    {
        Session::put($name_variable,$value);
        return $value;
    }

    static public function getSessionValue($name_variable,$default="")
    {
        $result=Session::get($name_variable);
        if(!$result) return $default;
        return $result;
    }

    /* ************************** */
    /*    BUDGET                  */
    /* ************************** */
    static public function getTotalVersements($annee,$type_aide="") {
        if(!$type_aide) {
            $total=Versement::select(db::raw('SUM(montant + montant_r) as total'))
                ->where('date','like',$annee.'%')
                ->value('total');
        } else {
            $total=Versement::select(db::raw('SUM(montant + montant_r) as total'))
                ->where('date','like',$annee.'%')
                ->where('type','=',$type_aide)
                ->value('total');
        }
        if(!$total) $total=0;
        return $total;
    }

	//getNB Etablissements
	static public function getSoldeBudget($type_aide="",$annee="") {
		if($annee=="") $annee=date("Y");
		$total_versements=MyApp::getTotalVersements($annee,$type_aide);
        if(!$total_versements) $total_versements=0;
        
        $solde=-$total_versements;
        //if($type_aide=="PAN") dd(MyApp::getBudget($type_aide));
		return MyApp::getBudget($type_aide)-$total_versements;
	}

	static public function getSoldePrcBudget($type_aide="",$annee="") {
		if($annee=="") $annee=date("Y");
        $budget=MyApp::getBudget($type_aide);
		$total_versements=MyApp::getTotalVersements($annee,$type_aide);
        if(!$budget) return "-";
        $prc=round(100/$budget*$total_versements,0);
		return $prc;
	}

	static public function getBudget($type_aide) {
		$montant=MyApp::getParam('CPT_BUDGET_'.$type_aide);
        if(!$montant) return 0;
		return intVal($montant);
	}

    /* ************************** */
    /*    AIDES A L'ENFANT CALCUL */
    /* ************************** */
    static public function getMontantAAE($nb_enfant)
    {
        $montant_soc=MyApp::getParam('AAE_MONTANT_SOC');
        $t_montant_soc=explode(";",$montant_soc);
        //Préparation dutableau de calcul
        //Dans la BDD sous la forme 1;5000 2;6000 3;8000 4;10000 5;12000 6;15000 7;18000
        $indemnite_nbenfant=0;
        $indemnite_montant=0;
        $t=array();
        for($i=1;$i<=20;$i++) { //Nb enfant max 20
            if(isset($t_montant_soc[$i-1])&&($t_montant_soc[$i-1]!="")) {
                $indemnite=explode("=",$t_montant_soc[$i-1]);
                $indemnite_nbenfant=$indemnite[0];
                $indemnite_montant=$indemnite[1];
            }
            $t[$i]=$indemnite_montant;
        }
        $t_montant_soc=$t;$montant_c=0;
        for($i=1;$i<=$nb_enfant;$i++) $montant_c+=$t_montant_soc[$i];
        $prime=MyApp::getPrimeExcept()*$nb_enfant;
        return $montant_c+$prime;
    }

    static public function getCertificatsAAE()
    {
        $certifs=MyApp::getParam('AAE_CERTIFICATS');
        $t_certifs=explode(";",$certifs);

        return $t_certifs;
    }

    //Regarde mois prime exceptionnelle
    static public function getPrimeExcept($date="")
    {
        if(!$date) $date=date('Y-m');
        $montant=0;
        $mois=MyApp::getParam('AAE_PRIME_EXEPT_MOIS');
        $prime=MyApp::getParam('AAE_PRIME_EXEPT');
        $t=explode("/",$mois);
        if(!isset($t[2]) || !isset($t[1])) return 0;
        $mois_annee=$t[2]."-".$t[1];
        if($mois_annee==$date) $montant=$prime;

        return $montant;
    }

    //Date de la  prime exceptionnelle
    static public function getDatePrimeExcept()
    {
        $mois=MyApp::getParam('AAE_PRIME_EXEPT_MOIS');
        $prime=MyApp::getParam('AAE_PRIME_EXEPT');
        $t=explode("/",$mois);
        $t[1]=str_pad($t[1],2,"0");
        $mois_annee="";
        if(isset(MyApp::MOIS_NUM[$t[1]])) $mois_annee=MyApp::MOIS_NUM[$t[1]]." ".$t[2];

        return $mois_annee;
    }

    /* ************************** */
    /*           FILET SOCIAL     */
    /* ************************** */


    /* ************************** */
    /*           DIVERS            */
    /* ************************** */
    static public function getAidesLibelle($type)
    {
        $type=strtolower($type);
        if(!isset(MyApp::TYPES_AIDES[$type])) return "";
        $aide=MyApp::TYPES_AIDES[$type];
        return $aide;
    }

    /* ************************** */
    /*           LISTES            */
    /* ************************** */

    static public function getZBase($nom)
    {
        $t = ZBase::where("nom","=",$nom)->orderby('ordre','ASC')->pluck('libelle','code')->toArray();
        return $t;
    }

    static public function getZBaseLibelle($nom,$code,$type='')
    {
        $base = ZBase::where("nom","=",$nom)->where("code","=",$code)->first();
        if(!$base) return "";
        return ($type=="court")?$base->libelle_court:$base->libelle;
    }
    
    static public function getDistrictPop()
    {
        $district=District::select(DB::raw("id,CONCAT(royaume,' (',ile,') - ',nom) as nom"))->pluck("nom","id")->toArray();
        return $district;
    }

    static public function getIdDistrictIle($ile)
    {
        $t_id=District::select("id")->where('ile','=',$ile)->pluck("nom","id")->toArray();
        return $t_id;
    }

    static public function getAnneesPop()
    {
        $annees=Vehicule::select(DB::raw("YEAR(date_emission) as annee"))->orderby('annee','desc')->pluck('annee','annee')->toArray();
        return $annees;
    }

    static public function getRolesPop()
    {
        $t=[];
        $t[] =["id"=>"","text"=>""];
        $roles=MyApp::BENEF_ROLES;
        foreach($roles as $key=>$role) {
            $t[] = ["id"=> $key,"text"=>$role];
        }
        return $t;
    }

    static public function getAidesPop()
    {
        $t=[];
        $t[] =["id"=>"","text"=>""];
        $aides=MyApp::TYPES_AIDES;
        foreach($aides as $key=>$aide) {
            $t[] = ["id"=> $key,"text"=>$aide];
        }
        return $t;
    }

    static public function getIdVillagePop($ile)
    {
        $villages=Village::select('villages.id')
            ->join('districts',"districts.id","=","villages.district_id")
            ->where("districts.ile","=",$ile)
            ->pluck('villages.id')
            ->toArray();
        return $villages;
    }

    static public function getVillagesPop()
    {
        $t=[];
        $row_name="CONCAT(villages.nom,' (',districts.nom,')',' - ',IF(districts.ile='F','FUTUNA','WALLIS')) as nom";
        $villages=Village::select(DB::raw("villages.id as id,".$row_name))->join('districts','districts.id','=','villages.id_district')->pluck("nom","id")->toArray();

        $t[] =["id"=>"","text"=>""];
        foreach($villages as $key=>$nom) {
            
            $t[] = ["id"=> $key,"text"=>$nom];
        }
        $t[] =["id"=>"999","text"=>"HORS TERRITOIRE"];
        return $t;
    }

    static public function getVillagesCPPop()
    {
        $villages=Village::select(DB::raw("villages.id as id,districts.code_postal as cp"))
            ->join('districts','districts.id','=','villages.id_district')
            ->pluck("cp","id")->toArray();
        $t=[];
        foreach($villages as $key=>$nom) {
            $t[$key] = $nom;
        }
        return $t;
    }

    static public function getListeAides() {
        $aides=MyApp::TYPES_AIDES;

        return $aides;
    }

    /* ************************** */
    /*    DATES
    /* ************************** */
    static public function getDayNans($n="18") {
        $date_aujourdhui = new DateTime();
        // date - 18 ans
        $date_18 = $date_aujourdhui->sub(new DateInterval('P'.$n.'Y'))->format('Y-m-d');
        return $date_18;
    }

    //Mois du premier versement
    static public function getMoisPremierVersement($type_aide) {
        $versement=DB::table('versements')->select(db::raw("LEFT(date,7) as mois"))->where('type','=',$type_aide)->orderBy('mois','asc')->first();
        if(!$versement) return ""; 
        return $versement->mois;
    }

    //Mois du premier versement
    static public function getListeMois($mois_dep,$mois_fin) {
        $t_mois=[];
        $mois_encours=$mois_dep;
        $t_mois[] = $mois_encours;$k=1;
        while($mois_fin>$mois_encours) {
            $mois_encours =  date('Y-m', strtotime('+ '.$k++.' month', strtotime($mois_dep."-01")));
            $t_mois[] = $mois_encours;
            if($k>180) break; //securité
        }
        return $t_mois;
    }

    

    /* ************************** */
    /*    PARAMETRES              */
    /* ************************** */
    static public function getParam($ref)
    {
        $parametre=Parametre::where('ref','=',$ref)->first();
        if(!$parametre) return "";
        return $parametre->value;
    }

    /* ************************** */
    /*    DIVERS
    /* ************************** */
    static function getUserIP()
    {
        $client  = @$_SERVER['HTTP_CLIENT_IP'];
        $forward = @$_SERVER['HTTP_X_FORWARDED_FOR'];
        $remote  = $_SERVER['REMOTE_ADDR'];

        if(filter_var($client, FILTER_VALIDATE_IP))
        {
            $ip = $client;
        }
        elseif(filter_var($forward, FILTER_VALIDATE_IP))
        {
            $ip = $forward;
        }
        else
        {
            $ip = $remote;
        }

        return $ip;
    }


    static public function CleanMontant($str)
    {

        $str=str_replace(",",".",$str);
        $str=str_replace(" ","",$str);
        if($str=="") $str=0;
        return floatVal($str);
    }
       // Remplace tous les accents par leur équivalent sans accent.

    static function enleveaccents($str) {
        $ch0 = array(
            "œ"=>"oe",
            "Œ"=>"OE",
            "æ"=>"ae",
            "Æ"=>"AE",
            "À" => "A",
            "Á" => "A",
            "Â" => "A",
            "à" => "A",
            "Ä" => "A",
            "Å" => "A",
            "&#256;" => "A",
            "&#258;" => "A",
            "&#461;" => "A",
            "&#7840;" => "A",
            "&#7842;" => "A",
            "&#7844;" => "A",
            "&#7846;" => "A",
            "&#7848;" => "A",
            "&#7850;" => "A",
            "&#7852;" => "A",
            "&#7854;" => "A",
            "&#7856;" => "A",
            "&#7858;" => "A",
            "&#7860;" => "A",
            "&#7862;" => "A",
            "&#506;" => "A",
            "&#260;" => "A",
            "à" => "a",
            "á" => "a",
            "â" => "a",
            "à" => "a",
            "ä" => "a",
            "å" => "a",
            "&#257;" => "a",
            "&#259;" => "a",
            "&#462;" => "a",
            "&#7841;" => "a",
            "&#7843;" => "a",
            "&#7845;" => "a",
            "&#7847;" => "a",
            "&#7849;" => "a",
            "&#7851;" => "a",
            "&#7853;" => "a",
            "&#7855;" => "a",
            "&#7857;" => "a",
            "&#7859;" => "a",
            "&#7861;" => "a",
            "&#7863;" => "a",
            "&#507;" => "a",
            "&#261;" => "a",
            "Ç" => "C",
            "&#262;" => "C",
            "&#264;" => "C",
            "&#266;" => "C",
            "&#268;" => "C",
            "ç" => "c",
            "&#263;" => "c",
            "&#265;" => "c",
            "&#267;" => "c",
            "&#269;" => "c",
            "Ð" => "D",
            "&#270;" => "D",
            "&#272;" => "D",
            "&#271;" => "d",
            "&#273;" => "d",
            "È" => "E",
            "É" => "E",
            "Ê" => "E",
            "Ë" => "E",
            "&#274;" => "E",
            "&#276;" => "E",
            "&#278;" => "E",
            "&#280;" => "E",
            "&#282;" => "E",
            "&#7864;" => "E",
            "&#7866;" => "E",
            "&#7868;" => "E",
            "&#7870;" => "E",
            "&#7872;" => "E",
            "&#7874;" => "E",
            "&#7876;" => "E",
            "&#7878;" => "E",
            "è" => "e",
            "é" => "e",
            "ê" => "e",
            "ë" => "e",
            "&#275;" => "e",
            "&#277;" => "e",
            "&#279;" => "e",
            "&#281;" => "e",
            "&#283;" => "e",
            "&#7865;" => "e",
            "&#7867;" => "e",
            "&#7869;" => "e",
            "&#7871;" => "e",
            "&#7873;" => "e",
            "&#7875;" => "e",
            "&#7877;" => "e",
            "&#7879;" => "e",
            "&#284;" => "G",
            "&#286;" => "G",
            "&#288;" => "G",
            "&#290;" => "G",
            "&#285;" => "g",
            "&#287;" => "g",
            "&#289;" => "g",
            "&#291;" => "g",
            "&#292;" => "H",
            "&#294;" => "H",
            "&#293;" => "h",
            "&#295;" => "h",
            "Ì" => "I",
            "Í" => "I",
            "Î" => "I",
            "Ï" => "I",
            "&#296;" => "I",
            "&#298;" => "I",
            "&#300;" => "I",
            "&#302;" => "I",
            "&#304;" => "I",
            "&#463;" => "I",
            "&#7880;" => "I",
            "&#7882;" => "I",
            "&#308;" => "J",
            "&#309;" => "j",
            "&#310;" => "K",
            "&#311;" => "k",
            "&#313;" => "L",
            "&#315;" => "L",
            "&#317;" => "L",
            "&#319;" => "L",
            "&#321;" => "L",
            "&#314;" => "l",
            "&#316;" => "l",
            "&#318;" => "l",
            "&#320;" => "l",
            "&#322;" => "l",
            "Ñ" => "N",
            "&#323;" => "N",
            "&#325;" => "N",
            "&#327;" => "N",
            "ñ" => "n",
            "&#324;" => "n",
            "&#326;" => "n",
            "&#328;" => "n",
            "&#329;" => "n",
            "Ò" => "O",
            "Ó" => "O",
            "Ô" => "O",
            "Õ" => "O",
            "Ö" => "O",
            "Ø" => "O",
            "&#332;" => "O",
            "&#334;" => "O",
            "&#336;" => "O",
            "&#416;" => "O",
            "&#465;" => "O",
            "&#510;" => "O",
            "&#7884;" => "O",
            "&#7886;" => "O",
            "&#7888;" => "O",
            "&#7890;" => "O",
            "&#7892;" => "O",
            "&#7894;" => "O",
            "&#7896;" => "O",
            "&#7898;" => "O",
            "&#7900;" => "O",
            "&#7902;" => "O",
            "&#7904;" => "O",
            "&#7906;" => "O",
            "ò" => "o",
            "ó" => "o",
            "ô" => "o",
            "õ" => "o",
            "ö" => "o",
            "ø" => "o",
            "&#333;" => "o",
            "&#335;" => "o",
            "&#337;" => "o",
            "&#417;" => "o",
            "&#466;" => "o",
            "&#511;" => "o",
            "&#7885;" => "o",
            "&#7887;" => "o",
            "&#7889;" => "o",
            "&#7891;" => "o",
            "&#7893;" => "o",
            "&#7895;" => "o",
            "&#7897;" => "o",
            "&#7899;" => "o",
            "&#7901;" => "o",
            "&#7903;" => "o",
            "&#7905;" => "o",
            "&#7907;" => "o",
            "ð" => "o",
            "&#340;" => "R",
            "&#342;" => "R",
            "&#344;" => "R",
            "&#341;" => "r",
            "&#343;" => "r",
            "&#345;" => "r",
            "&#346;" => "S",
            "&#348;" => "S",
            "&#350;" => "S",
            "&#347;" => "s",
            "&#349;" => "s",
            "&#351;" => "s",
            "&#354;" => "T",
            "&#356;" => "T",
            "&#358;" => "T",
            "&#355;" => "t",
            "&#357;" => "t",
            "&#359;" => "t",
            "Ù" => "U",
            "Ú" => "U",
            "Û" => "U",
            "Ü" => "U",
            "&#360;" => "U",
            "&#362;" => "U",
            "&#364;" => "U",
            "&#366;" => "U",
            "&#368;" => "U",
            "&#370;" => "U",
            "&#431;" => "U",
            "&#467;" => "U",
            "&#469;" => "U",
            "&#471;" => "U",
            "&#473;" => "U",
            "&#475;" => "U",
            "&#7908;" => "U",
            "&#7910;" => "U",
            "&#7912;" => "U",
            "&#7914;" => "U",
            "&#7916;" => "U",
            "&#7918;" => "U",
            "&#7920;" => "U",
            "ù" => "u",
            "ú" => "u",
            "û" => "u",
            "ü" => "u",
            "&#361;" => "u",
            "&#363;" => "u",
            "&#365;" => "u",
            "&#367;" => "u",
            "&#369;" => "u",
            "&#371;" => "u",
            "&#432;" => "u",
            "&#468;" => "u",
            "&#470;" => "u",
            "&#472;" => "u",
            "&#474;" => "u",
            "&#476;" => "u",
            "&#7909;" => "u",
            "&#7911;" => "u",
            "&#7913;" => "u",
            "&#7915;" => "u",
            "&#7917;" => "u",
            "&#7919;" => "u",
            "&#7921;" => "u",
            "&#372;" => "W",
            "&#7808;" => "W",
            "&#7810;" => "W",
            "&#7812;" => "W",
            "&#373;" => "w",
            "&#7809;" => "w",
            "&#7811;" => "w",
            "&#7813;" => "w",
            "Ý" => "Y",
            "&#374;" => "Y",
            "?" => "Y",
            "&#7922;" => "Y",
            "&#7928;" => "Y",
            "&#7926;" => "Y",
            "&#7924;" => "Y",
            "ý" => "y",
            "ÿ" => "y",
            "&#375;" => "y",
            "&#7929;" => "y",
            "&#7925;" => "y",
            "&#7927;" => "y",
            "&#7923;" => "y",
            "&#377;" => "Z",
            "&#379;" => "Z"
            );
        $str = strtr($str,$ch0);
        return $str;
    }

    static function enleveaccents_old($chaine)
    {
     $string= strtr($chaine,
        "ÀÁÂàÄÅàáâàäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ",
        "aaaaaaaaaaaaooooooooooooeeeeeeeecciiiiiiiiuuuuuuuuynn");
     return $string;
    }


}
