<?php namespace App\Models\Sipre;

use Illuminate\Database\Eloquent\Model;
use App\Models\Allocataire;
use DB;
class SipreBeneficiaire extends Model {


	protected $table = 'beneficiaires';
    protected $connection = 'mysql2';
    //protected $primaryKey = 'id';


    /* Dates */
    public function getDates()
    {
            return array('datenaiss','ret_dateed','date_pi');
    }


    public function getDateNaissFRAttribute($value)
    {
        return ($this->attributes['datenaiss']!=null)?date('d/m/Y', strtotime($this->attributes['datenaiss'])):null;
    }

     public function getDateDecesFRAttribute($value)
    {
        return ($this->attributes['date_deces']!=null)?date('d/m/Y', strtotime($this->attributes['date_deces'])):null;
    }

     public function getRetDateedFRAttribute($value)
    {
        return ($this->attributes['ret_dateed']!=null)?date('d/m/Y', strtotime($this->attributes['ret_dateed'])):null;
    }
     public function getDatePiFRAttribute($value)
    {
        return (($this->attributes['date_pi']!=null))?date('d/m/Y', strtotime($this->attributes['date_pi'])):null;
    }

    

    /* IdSITAS */
    public function getIdSITASAttribute()
    {
        $allocataire=Allocataire::where('id_cpswf','=',$this->id)->first();
        if(!$allocataire) return "";
        return $allocataire->IdPAD;
    }

    /* Nom */
    public function getNomCompletAttribute()
    {
            return $this->nom." ".$this->prenom;
    }


    /* Conjoint */
    public function getNomConjointAttribute()
    {
        $nom_conjoint="";
        $conjoint  = SipreBeneficiaire::where('id', '=', $this->conjoint)->first();
        if($conjoint) $nom_conjoint =trim($conjoint->nom)." ".trim($conjoint->prenom);
        return $nom_conjoint;
    }

     /* Nb Enfants */
    public function getNbEnfantsAttribute()
    {
        $nb = SipreEnfant::where('parents1', '=', $this->id)
            ->orwhere('parents2', '=', $this->id)
            ->count();
        return $nb;
    }

    
    /* Nb Enfants */
    public function getEnfants()
    {
        $enfants = SipreEnfant::where('parents1', '=', $this->id)
            ->orwhere('parents2', '=', $this->id)
            ->get();
        return $enfants;
    }

        /**
     * Nombre d'enfants pour Aide Sociale
     */
    public function getNbEnfantsAAEAttribute()
    {
        $nb=DB::connection('mysql2')->table('enfants')
        ->where('parents1', '=', $this->id)
        ->whereIn('certif',array('1','2','3','4'))
        ->count();
        return $nb;
    }

}
