<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VersementPrepa extends Model
{
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'versements_prepa';

    /* Dates */
    public function getDates()
    {
        return array('procuration_date_naissance','procuration_date_debut','procuration_date_fin','updated_at','created_at');
    }


    public function getProcurationDateNaissanceAttribute($value)
    {
        return ($this->attributes['procuration_date_naissance']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_naissance'])):null;
    }
    public function getProcurationDateNaissanceUSAttribute($value)
    {
        return ($this->attributes['procuration_date_naissance']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_naissance'])):null;
    }
    public function getProcurationDateDebutAttribute($value)
    {
        return ($this->attributes['procuration_date_debut']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_debut'])):null;
    }
    public function getProcurationDateDebutUSAttribute($value)
    {
        return ($this->attributes['procuration_date_debut']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_debut'])):null;
    }
    public function getProcurationDateFinAttribute($value)
    {
        return ($this->attributes['procuration_date_fin']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_fin'])):null;
    }
    public function getProcurationDateFinUSAttribute($value)
    {
        return ($this->attributes['procuration_date_fin']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_fin'])):null;
    }
    

    public function getIdPADAttribute()
    {
        return str_pad($this->id, 5, "0", STR_PAD_LEFT);
    }
    
	public function getAllocataire()
    {
        $allocataire=Allocataire::find($this->id_allocataire);
        if(!$allocataire) return "";
        return $allocataire;
    }

	public function getAllocataireIdPADAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->IdPAD;
    }

	public function getAllocataireNomCompletAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->NomComplet;
    }

	public function getAllocataireDateNaissanceAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->DateNaissance;
    }

	public function getAllocataireNbEnfantsAAEAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->NbEnfantsAAE;
    }
	

	public function getMoisAttribute()
    {
        $mois=date('m', strtotime($this->attributes['ret_date']));
        $libelle=MyApp::MOIS_NUM[$mois];
        return $libelle;
    }

    
    /* TITULAIRE */
    public function getIsTitulaireAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->IsTitulaire;
    }


    
    /***********/
    /* PAN / ENfants */
    /***********/
    public function getEnfantsPANListe()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->getEnfantsPANListe();
    }
    


    /***********/
    /* BANQUES */
    /***********/
	public function getBanqueNomAttribute()
    {
        $banque=Banque::find($this->id_banque);
        if($banque) return $banque->nom;
        return "";
    }


    //Vérification si compte bancaire OK (>=21)
	public function getCompteOKAttribute()
    {
        $size_IBAN=MyApp::SIZE_IBAN;
        if(strlen($this->compte)==$size_IBAN) return true;
        return false;
    }

    //Revoi la liste des erraures sur le RIB
	public function getCompteError($sep="<br/>")
    {
        $error="";$size_IBAN=MyApp::SIZE_IBAN;
        if(strlen($this->compte)==0) $error="Aucun IBAN de défini";
        else {
            if(!$this->CompteOK) $error="IBAN comprends ".strlen($this->compte)." au lieu des ".$size_IBAN." caractères attendus";
            /*
            $nb=0;
            foreach(MyApp::FORMAT_COMPTE_IBAN as $champ=>$taille) {
                $champs="";
                if(strlen(trim($this->{$champ})!=$taille)) {
                    $champs=(($champs!="")?$sep:"").$champ;
                    $nb++;
                }
            }
            $error="Mauvais format pour ".(($nb==1)?"le":"les")." champ".(($nb==1)?"":"s")." : ".$champs;
            */
        }
        return $error;
    }
}