<?php namespace App\Models;


use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;

class Village extends Model
{
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'villages';
	public  $timestamps = false;



     public function getFullNameAttribute($value)
    {
        $district=District::find($this->id_district);
        if(!$district) return "";
        return $this->nom." (".$district->code_postal." ".$district->royaume.")";
    }

    public function getFullName2Attribute($value)
    {
        $district=District::find($this->id_district);
        if(!$district) return "";
        return $this->nom." (".$district->ile.")";
    }

     public function getDistrictAttribute($value)
    {
    	$district=District::find($this->id_district);
        if(!$district) return "";
        return $district->nom;
    }

     public function getRoyaumeAttribute($value)
    {
    	$district=District::find($this->id_district);
        if(!$district) return "";
        return $district->royaume;
    }

    public function getIleAttribute()
    {
        $district=District::find($this->id_district);
        if(!$district) return "";
        return $district->ile;
    }

    /**
    * Fiche Supprimable ?
    */
    public function getIsSupprimableAttribute()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if (!$user->can("VIL_SUP") && !$user->HasRole("ADMINISTRATEUR")) return false;
        $nb=$this->NbVehicules;
        if($nb>0) return false;

        return true;
    }


}