@extends('layouts.dash')
@section('title') Allocataires @stop
@section('title_card') Allocataires @stop

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif


    <div class="card">
        <div class="card-header bg-{{ App\Models\MyApp::COLOR_AIDES[$type_aide] }}">
            <h2 class="card-title">Liste des allocataire - {{ $title }}</h2>
        </div>
        <div class="card-body">
            <div class="row">
                <div class='col-md-2'>
                    {!! html()->label('Ile','select_ile') !!}
                    {!! html()->select('select_ile',App\Models\MyApp::ILES,isset($ile)?$ile:"")->placeholder('Toutes')->attributes(['class' => 'form-control','id' => 'select_ile'])  !!}
                </div>
            </div>
            <table id="_table" style="background-color:white;width:100%" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th width='1px'>Id</th>
                        <th width='1px'>Dossier<br/>Famille</th>
                        <th width='1px'>CPSWF</th>
                        <th >Nom</th>
                        <th >Village</th>
                        <th width='1px'>Date de naissance</th>
                        <th width='1px'>Droits</th>
                        <th >Conjoint</th>
                        <th width='1px'>NbEnfants<br/>Soc</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'>Mise à jour</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($allocataires as $allocataire)
                        <tr>
                            <td  >
                                <a class="btn bg-secondary" href="{!! url('allocataires/'.$allocataire->id) !!}">{!! $allocataire->IdPAD !!}</a>
                                @if($allocataire->controle)<br\>
                                    <span title="A Contrôler" class="right badge badge-danger">CTL</span>
                                @endif
                            </td>
                            <td>
                                @if($allocataire->id_famille)
                                    <a class="btn bg-primary" href="{!! url('familles/'.$allocataire->id_famille) !!}">{!! $allocataire->IdPADFamille !!}</a>
                                @else
                                    <span class="badge badge-info right"> Aucun</span>
                                @endif
                            </td>
                            <td>{!! $allocataire->IdCPSWFPAD !!}</td>
                            <td>{!! $allocataire->nom_complet2 !!}
                                @if ($allocataire->statut_dossier!="ACT")
                                    <span class="right badge badge-danger">Inactif</span>    
                                @endif
                            </td>
                            <td nowrap>{!! $allocataire->VillageFullName2 !!}</td>
                            <td align="center">{!! $allocataire->date_naissance !!}</td>
                            <td align="center">{!! $allocataire->getDroitsOuvertureBadge($type_aide,"",true) !!}</td>
                            <td>{!! $allocataire->ConjointNomComplet !!}</td>
                            <td align="center">{!! $allocataire->NbEnfantsAAE !!}</td>
                            <td align="center">{!! $allocataire->statut !!}</td>
                            <td align="center" title="Création le {!! $allocataire->CreatedAt !!}">{!! $allocataire->UpdatedAt !!}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable_btn")
    @include("aides.scripts_aides")
@endsection
