@extends('layouts.dash')
@section('title') Allocataires @stop
@section('title_card')  @stop

@section('content')
    <div class="card">
        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif

        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif

        @if (Session::has('success'))
            <div class="alert alert-success">{!! \Session::get('success') !!}</div>
        @endif

        {{ html()->form('POST', url('/set_statut_'.strtolower($type_aide)))->open() }} 
            <input type="hidden" name="list_check" id='list_check' value="">
            <input type="hidden" name="type_aide" id='list_check' value="{{ $type_aide }}">


        <div class="card-header bg-info">
            <h2 class="card-title">{{ $title }}</h2>
        </div>
        <div class="card-body">
            <table id="_table" style="background-color:white;width:100%" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th width="1px" nowrap>Sel.
                            <input id="box_all" class="form-control" name="sel" type="checkbox" value="1" onchange='select_all();'>
                        </th>
                        <th width='1px'>Id</th>
                        <th width='1px'>Dossier<br/>Famille</th>
                        <th width='1px'>CPSWF</th>
                        <th >Nom</th>
                        <th width='1px'>Date de naissance</th>
                        <th width='1px'>Age</th>
                        <th >Conjoint</th>
                        @if($type_aide=="AAE")
                            <th >Enfants bénéficiaires</th>
                            <th width='1px'>NbEnfants<br/>Tot/AideEnf.</th>
                        @endif
                        @if($type_aide=="FSO")
                            <th width='1px'>NbPersonnes</th>
                            <th width='1px'>Ressources</th>
                            <th width='1px'>QF</th>
                        @endif
                        <th width='1px'>Aides</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($allocataires as $allocataire)
                        <tr>
                            <td style='margin:0px'>
                                <input id="box_{!! $allocataire->id !!}" class="form-control" name="box_{!! $allocataire->id !!}" type="checkbox" value="1" onchange='calcul_select();'>
                                @if($allocataire->controle)<br\>
                                    <span title="A Contrôler" class="right badge badge-danger">CTL</span>
                                @endif
                            </td>
                            <td  >
                                <a class="btn bg-secondary" href="{!! url('allocataires/'.$allocataire->id) !!}">{!! $allocataire->IdPAD !!}</a>
                            </td>
                            <td>
                                @if($allocataire->id_famille)
                                    <a class="btn bg-primary" href="{!! url('familles/'.$allocataire->id_famille) !!}">{!! $allocataire->IdPADFamille !!}</a>
                                @else
                                    <span class="badge badge-info right"> Aucun</span>
                                @endif
                            </td>
                            <td>{!! $allocataire->IdCPSWFPAD !!}</td>
                            <td>{!! $allocataire->nom_complet2 !!}
                                @if ($allocataire->statut_dossier!="ACT")
                                    <span class="right badge badge-danger">Inactif</span>    
                                @endif
                            </td>
                            <td align="center">{!! $allocataire->date_naissance !!}</td>
                            <td align="center">{!! $allocataire->age !!}</td>
                            <td>{!! $allocataire->FamilleConjointNomComplet !!}</td>
                            @if($type_aide=="AAE")
                                <td>{!! $allocataire->getEnfantsListe() !!}</td>
                                <td align="center">{!! $allocataire->NbEnfants."/".$allocataire->NbEnfantsAAE !!}</td>
                            @endif
                            @if($type_aide=="FSO")
                                <td align="right">{!! $allocataire->FamilleNbPersonnes !!}</td>
                                <td align="right">{!! $allocataire->FamilleMontantRessources !!}</td>
                                <td align="right">{!! $allocataire->QF !!}</td>
                            @endif
                            <td align="center">{!! $allocataire->types_aides !!}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="card-footer">
            @if(count($t_lignes)>0)
                <div class='form-group row'>
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-success"
                            onclick='if(!confirm("Voulez-vous vraiment mettre à jour le statut des Allocataires selectionnés ?")) return false;'>Mettre à jour le statut</a>
                    </div>
                </div>
            @endif
        </div>
        {{ html()->form()->close() }}
    </div>
@endsection


@section('scripts')

    <script>
        function select_all() {
            var lst="";
            var t_lignes={!! json_encode($t_lignes) !!};
            var check=$('#box_all').prop('checked');
            if(check) check="checked";
            for(var i=0;i<t_lignes.length;i++) {
                $('#box_'+t_lignes[i]).prop("checked",check);
                var checkbox=$('#box_'+t_lignes[i]).prop('checked');
                if(checkbox) {
                    lst+=((lst=="")?"":";")+t_lignes[i];
                }
            }
            set_list(lst);
        }

        function calcul_select() {
            var t_lignes={!! json_encode($t_lignes) !!};
            var lst="";
            for(var i=0;i<t_lignes.length;i++) {
                var check=$('#box_'+t_lignes[i]).prop('checked');
                if(check) {
                    lst+=((lst=="")?"":";")+t_lignes[i];
                }
            }
            set_list(lst);
        }

        function set_list(lst="") {
            $('#list_check').val(lst);

            var nt_lst=lst.split(";");
            var nb = nt_lst.length;
        }

        function init_list() {
            var lst=$('#list_check').val();
            var nt_lst=lst.split(";");
            for(var i=0;i<nt_lst.length;i++) {
                $('#box_'+nt_lst[i]).prop('checked',true);
            }
            set_list(lst);
        }

        init_list();
    </script>

<script>
    $(function () {
            var table =$('#_table').dataTable( {
                bAutoWidth: false,bPaginate: false,bInfo: true,
                bFilter: true,deferRender:    false,
                scrollCollapse: false,scroller:false,iDisplayLength:10,
                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                    "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                        ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                        "sSearch":"Chercher ",
                    buttons: {
                        colvis: 'Colonnes',
                        copy: 'Copier',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                            }
                        }
                    },
                dom: "<'row'<'col-sm-1 text-left'f><'col-sm-4'><'col-sm-6 text-right'>>" +
                    "<'row'<'col-sm-12't>>B" +"<'row'<'col-sm-5'i><'col-sm-7'p>>",
                    
                "buttons": ["copy", "excel", "colvis"],
                "columnDefs": [
                    { "targets": [ 0], "orderable": false,"searchable": false, "visible": true},
                ]

            });
    });
  </script>
@endsection
