@extends('layouts.dash_pop')


@section('content')
    <div class="card card-info">
        <div class="card-header">
            <h3 class="card-title">{!! $titre_versement !!}</h3>
        </div>
        <div align="center" class="card-body">
            <div class="col-lg-12">
                @if(count($enfants)==0)
                    <div class="bg-danger alert">
                        Aucun enfant n'est actuellement concerné par cette opération.
                    </div>
                @else
                    <table id="_table" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1%'>Id</th>
                                <th>Nom</th>
                                <th width='1%'>Sexe</th>
                                <th width='1%'>Date de naissance</th>
                                <th width='1%'>Age</th>
                                <th width='1%'>Certificat</th>
                                <th width='1%'>Nouveau Certificat</th>
                                <th width='10%'>Responsable</th>
                                <th width='10%'>Famille</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($enfants as $enfant)
                                <?php $class=($enfant->NewCertificat==$enfant->certificat_enfant )?'secndary':'danger'; ?>
                                <tr>
                                    <td>
                                        <a class="btn bg-secondary"  target='_blank'  href="{!! url('enfants/'.$enfant->id) !!}">
                                        {!! $enfant->IdPAD !!}
                                        </a>
                                    </td>
                                    <td>{!! $enfant->NomComplet  !!}</td>
                                    <td nowrap>{!! $enfant->sexe !!}</td>
                                    <td nowrap align="center">{!! $enfant->date_naissance !!}</td>
                                    <td nowrap align="center">{!! $enfant->age !!}</td>
                                    <td nowrap align="center">{!! $enfant->certificat_enfant !!}</td>
                                    <td nowrap align="center" class="bg-{!! $class !!}">{!! $enfant->NewCertificat !!}</td>
                                    <td>{!! $enfant->NomCompletResponsable1 !!}</td>
                                    <td><a class="btn bg-primary" target='_blank' href="{!! url('familles/'.$enfant->id_famille) !!}">{!! $enfant->IdPADFamille !!}</a></td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            </div>
        </div>
    </div>
@stop

@section('scripts')
    @include("forms.scripts_datatable_btn")
@endsection







