@extends('layouts.dash')

@section('title') {!! env('APP_NAME') !!} @stop
@section('title_card',$dashboard_title)
@section('content')


    <section class="content">
        <div class="container-fluid">
            <!-- Main row -->
            @if (Session::has('message'))
                <div class="alert alert-warning">{!! Session::get('message') !!}</div>
            @endif


            <!-- Small boxes (Stat box) -->
            @if($menu_home=="")
                @include('forms.boxes')
            @else
                @include('forms.boxes_'.$menu_home)
            @endif

            <div class='col-md-8 offset-md-5'>
                <div class="row">
                    <div class='col-md-3 form-group '>
                        {!! html()->text('lib_allocataire', null)->placeholder("chercher...")
                            ->attributes(['id' => 'lib_allocataire','class' => 'form-control']) !!}
                        <input type="hidden" name="id_allocataire" id='id_allocataire' value="">
                    </div>
                    <!--
                    <div class='col-md-2 col-lg-offset-2'>
                        <a href="#" id='btn_search_allocataire' class="btn bg-info"><i class="fa fa-search"></i></a>
                    </div>
                    -->
                </div>
            </div>
            
        <!-- /.row (main row) -->
        </div><!-- /.container-fluid -->
    </section>
@endsection

<style>
    .toast{
        opacity: 1 !important;
    }
</style>
@section('scripts')


    <script type="text/javascript">
        //Saisie conjoint
        $("#btn_search_allocataire").click(function() {set_alloc();})
        $("#lib_allocataire").on( "focus", function()  {$('#lib_allocataire').val('');})

        $(".icon-box").mouseenter(  function()  {
            $(this).css('transform','scale(1.1)');
        })
        $(".icon-box").mouseleave(  function()  {
            $(this).css('transform','scale(1)');
        })

        @if($menu_home=="" or $menu_home=="parametres")
            toastr.options = {
                "closeButton": false,
                "debug": false,
                "newestOnTop": true,
                "progressBar": false,
                "positionClass": "toast-top-right",
                "preventDuplicates": false,
                "onclick": null,
                "preventDuplicates": true,
                "showDuration": "200",
                "hideDuration": "200",
                "timeOut": "10000",
                "extendedTimeOut": "200",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
            }

            i=0;
            @foreach($types_aides as $type_aide=>$libelle)
            $('.toastrDefaultInfo_{{ strtolower($type_aide) }}').click(function() {
                i++;
                let newclass='bg-{{ App\Models\MyApp::COLOR_AIDES[$type_aide] }}';
                obj=toastr.info('<b>{{ $libelle }}</b><br/>Budget:&nbsp;<b>{{ $t_indicateurs["budget_".strtolower($type_aide)] }}</b>CFP</br>Distribué:&nbsp;<b>{{ $t_indicateurs["budget_dist_".strtolower($type_aide)] }}</b>CFP</br>Restant:&nbsp;<b>{{ $t_indicateurs["budget_rst_".strtolower($type_aide)] }}</b>CFP')
                obj.attr("id",'toastid_'+i);
                obj.addClass(newclass);
            });
            @endforeach
            $('.toastrDefaultInfo_all').click(function() {
                i++;
                let newclass='bg-primary';
                obj=toastr.info('<b>Toutes les Aides</b><br/>Budget:&nbsp;<b>{{ $t_indicateurs["budget_all"] }}</b>CFP</br>Distribué:&nbsp;<b>{{ $t_indicateurs["budget_dist_all"] }}</b>CFP</br>Restant:&nbsp;<b>{{ $t_indicateurs["budget_rst_all"] }}</b>CFP')
                obj.attr("id",'toastid_all');
                obj.addClass(newclass);
            });



            $("#lib_allocataire").autocomplete({
                source: "{!! url('auto_alloc_home') !!}",
                minLength: 2,
                autofocus:true,
                select: function(event, ui) {
                    var id=ui.item.id;
                    var mode=ui.item.mode;
                    var idPAD=id.toString().padStart(5,"0");
                    $('#id_allocataire').val(id);
                    set_alloc(mode);
                    
                },
                change: function( event, ui ) {
                },

                focus( event, ui ) {},
                response: function( event, ui ) {},
                open: function(){
                    $('.ui-autocomplete').css('width', '550px'); // HERE
                    $(".ui-autocomplete").css('background-color','lightgrey');
                }
            });
            
            function set_alloc(mode) {
                var id = $('#id_allocataire').val();
                if(!id) return;
                if(mode=="F") url="{!! url('familles') !!}"+"/"+id;
                else url="{!! url('allocataires') !!}"+"/"+id;
                location.href=url;
            }
        @endif


    </script>

@stop
