@extends('layouts.dash')
@section('title') Importations @stop
@section('title_card') Données CPSWF @stop

@section('content')
    <div class="card">
        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif

        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif

        @if (Session::has('success'))
            <div class="alert alert-success">{!! \Session::get('success') !!}</div>
        @endif

        {{ html()->form('POST', url('/importation_beneficiaires'))->open() }} 
            <input type="hidden" name="list_check" id='list_check' value="">
            <input type="hidden" name="type" id='type' value="{{ $type }}">

            <div class="card-header bg-info">
                <h2 class="card-title">{{ $title }}</h2>

            </div>
            <div class="card-body">
                <table id="_table" style="background-color:white;width:100%" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th width="1px">Sel.
                                <input id="box_all" class="form-control" name="sel" type="checkbox" value="1" onchange='select_all();'>
                            </th>
                            <th width='1px'>N°CPSWF</th>
                            <th width='1px'>N°SITAS</th>
                            <th>Nom</th>
                            <th width='1px'>Date de<br/>Naissance</th>
                            @if($type=='AAE')
                                <th>Enfants<br/>Soc/Tot</th>
                            @endif
                            <th>Conjoint</th>
                            <th width='1px'>Statut</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($sipre_beneficiaires as $beneficiaire)
                            <tr>
                                <td style='margin:0px'>
                                    @if(!$beneficiaire->IdSITAS)
                                        @if (($type!="AAE") || (($type=="AAE") && ($beneficiaire->NbEnfantsAAE)>0) )
                                            <input id="box_{!! $beneficiaire->id !!}" class="form-control" name="box_{!! $beneficiaire->id !!}" type="checkbox" value="1" onchange='calcul_select();'>
                                        @endif
                                    @endif
                                </td>
                                <td >{!! str_pad($beneficiaire->id, 5, "0", STR_PAD_LEFT) !!}</td>
                                <td >{!! $beneficiaire->IdSITAS !!}</td>
                                <td >{!! $beneficiaire->nom_complet !!}</td>
                                <td align="center">{!! $beneficiaire->DateNaissFR !!}</td>
                                @if($type=='AAE')
                                    <td align="center">{!! $beneficiaire->NbEnfantsAAE."/".$beneficiaire->NbEnfants !!}</td>
                                @endif
                                <td >{!! $beneficiaire->nom_conjoint !!}</td>
                                <td >{!! $beneficiaire->statut !!}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="card-footer">
                @if($t_lignes->count()>0)
                    <div class='form-group row'>
                        <div class="col-md-12">
                            <button type="submit" class="btn btn-success"
                                onclick='if(!confirm("Voulez-vous vraiment importer les bénéficiaires ?")) return false;'>Transférer les lignes sélectionnées</a>
                        </div>
                    </div>
                @endif
            </div>
        {{ html()->form()->close() }}
    </div>
@endsection


@section('scripts')

<script>
        function select_all() {
            var lst="";
            var t_lignes={!! json_encode($t_lignes) !!};
            var check=$('#box_all').prop('checked');
            if(check) check="checked";
            for(var i=0;i<t_lignes.length;i++) {
                $('#box_'+t_lignes[i].id).prop("checked",check);
                var checkbox=$('#box_'+t_lignes[i].id).prop('checked');
                if(checkbox) {
                    lst+=((lst=="")?"":";")+t_lignes[i].id;
                }
            }
            set_list(lst);
        }

        function calcul_select() {
            var t_lignes={!! json_encode($t_lignes) !!};
            var lst="";
            for(var i=0;i<t_lignes.length;i++) {
                var check=$('#box_'+t_lignes[i].id).prop('checked');
                if(check) {
                    lst+=((lst=="")?"":";")+t_lignes[i].id;
                }
            }
            set_list(lst);
        }

        function set_list(lst="") {
            $('#list_check').val(lst);

            var nt_lst=lst.split(";");
            var nb = nt_lst.length;
        }

        function init_list() {
            var lst=$('#list_check').val();
            var nt_lst=lst.split(";");
            for(var i=0;i<nt_lst.length;i++) {
                $('#box_'+nt_lst[i]).prop('checked',true);
            }
            set_list(lst);
        }

        init_list();
</script>


<script>
    $(function () {
            var table =$('#_table').dataTable( {
                bAutoWidth: false,bPaginate: false,bInfo: true,
                bFilter: true,deferRender:    false,
                scrollCollapse: false,scroller:false,iDisplayLength:10,
                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                    "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                        ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                        "sSearch":"Chercher ",
                    buttons: {
                        colvis: 'Colonnes',
                        copy: 'Copier',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                            }
                        }
                    },
                dom: "<'row'<'col-sm-1 text-left'f><'col-sm-4'><'col-sm-6 text-right'>>" +
                    "<'row'<'col-sm-12't>>B" +"<'row'<'col-sm-5'i><'col-sm-7'p>>",
                    
                "buttons": ["copy", "excel", "colvis"],
                "columnDefs": [
                    { 
                        "targets": [0], 
                        "orderable": false,
                        "searchable": false, 
                        "visible": true
                    },
                ]

            });
    });
  </script>
@endsection

