@extends('layouts.dash')

@section('title') Districts @stop

@section('subtitle_card',"")
@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header">
            <h3>Districts</h3>
        </div>
        <div class="card-body">
            @if($user->can("VIL_AJO") || $user->HasRole("ADMINISTRATEUR"))
                 <div class="row">
                    <a href="{{ url('districts/create') }}" class="btn btn-success">Ajouter un District</a>
                </div>
            @endif
            <table id="_table" class="table table-condensed table-striped table-bordered table-hover">
                <thead>
                    <tr>
                        <th>District</th>
                        <th>Code Postal</th>
                        <th>Royaume</th>
                        <th>Nb Vehicules</th>
                    </tr>
                </thead>
     
                <tbody>
                    @foreach ($districts as $district)
                    <tr>
                        <td>
                            <a href="./districts/{!! $district->id !!}">
                            {!! $district->nom !!}
                            </a>
                        </td>
                        <td>{!! $district->code_postal !!}</td>
                        <td>{!! $district->royaume !!}</td>
                        <td>{!! $district->nb_vehicules !!}</td> 
                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>
@endsection

@section('scripts')
    @include("forms.scripts_datatable_nopage")
@endsection


