@extends('layouts.dash')

@section('title') Villages @stop

@section('subtitle_card',"")
@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header">
            <h3>Villages</h3>
        </div>
        <div class="card-body">
            @if($user->can("VIL_AJO") || $user->HasRole("ADMINISTRATEUR"))
                 <div class="row">
                    <a href="{{ url('villages/create') }}" class="btn btn-success">Ajouter un Village</a>
                </div>
            @endif
            <table id="_table" class="table table-condensed table-striped table-bordered table-hover">
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th>District</th>
                        <th>Royaume</th>
                        <th>Nb Vehicules</th>
                    </tr>
                </thead>
     
                <tbody>
                    @foreach ($villages as $village)
                    <tr>
                        <td>
                            <a href="./villages/{!! $village->id !!}">
                            {!! $village->nom !!}
                            </a>
                        </td>
                        <td>{!! $village->district !!}</td>
                        <td>{!! $village->royaume !!}</td>
                        <td>{!! $village->nb_vehicules !!}</td> 
                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>
@endsection

@section('scripts')
    @include("forms.scripts_datatable_btn")
@endsection


