@extends('layouts.dash')

@section('title') TBases @stop

@section('subtitle_card',"")
@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header">
            <h3>zbases</h3>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-5">
                    {!! html()->select('select_base',$liste_bases,$zbase)
                        ->placeholder('')->attributes(['id' => 'select_base','class' => 'form-control'])  !!}
                </div>
                @if($user->HasRole("ADMINISTRATEUR")|| ($user->can("BAS_AJO")&&($zbase)))
                    <a href="{{ url('zbases_create/'.$zbase) }}" class="btn btn-success">Ajouter une Fiche</a>
                @endif
            </div>
            <br/>
            <div class="row">
                <table id="_table" class="table table-condensed table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Code</th>
                            <th>Libelle</th>
                            <th>Ordre</th>
                        </tr>
                    </thead>
        
                    <tbody>
                        @foreach ($zbases as $base)
                        <tr>
                            <td>
                                <a href="{{ url('zbases/'.$base->id) }}">
                                    {!! $base->code !!}
                                </a>
                            </td>
                            <td>{!! $base->libelle !!}</td>
                            <td>{!! $base->ordre !!}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(function () {
            $('#select_base').change(function() {select_filtre();});

            function select_filtre() {
                var base=$('#select_base').val();
                if(base=="") base=0;
                url="{!! url('zbases_filtre/') !!}/"+base;
                location.href=url;
            }
        });
    </script>

    <script>
    $(function () {
      $("#_table").DataTable({
        "paging": true,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "info": true,
        "responsive": false,
        "autoWidth": false,
        "fixedHeader": true,
         oLanguage: {
              "sZeroRecords": "Aucune ligne",
              "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
              "sInfoEmpty": "Showing 0 to 0 of 0 records",
              "sInfoFiltered": "(sur un total de _MAX_ lignes)",
              "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                  ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                  "sSearch":"Chercher",
              buttons: {
                  colvis: 'Colonnes à afficher',
                  copy: 'Copier',print: 'Imprimer',
                  copyTitle: 'Ajouté au presse-papiers',
                  copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                  copySuccess: {
                      _: '%d lignes copiées',
                      1: '1 ligne copiée'
                      }
                  }
  
          },
          dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",
  
          "buttons": ["copy"] //"print", "pdf", "csv",
      })
      .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');
  
    });
  </script>
@endsection


