
{!! html()->hidden('id_allocataire', isset($allocataire_id)?$allocataire_id:null)->attributes(['id' => 'id_allocataire']) !!}
@if(!$mode_frame)
    <div class="form-group row">
        <div class="col-md-6">
            {!! html()->label( 'Allocataire','id_allocataire') !!}
            <div class="input-group ">
                <div class="input-group-prepend">
                    <span class="input-group-text"  name="allocataire_addon" id='allocataire_addon'>{!! isset($ressource->id_allocataire)?str_pad($ressource->id_allocataire, 6, "0", STR_PAD_LEFT):'' !!}</span>
                </div>
                {!! html()->text('allocataire', isset($ressource->id_allocataire)?$ressource->NomCompletAllocataire:'')
                    ->attributes([($mode=="show"?'disabled':''), 'id'=>'allocataire','class' => 'form-control'])
                !!}
            </div>
        </div>
    </div>
@endif

<div class="form-group row">
    <div class="col-md-6">
        {!! html()->label( 'Type de ressource','type_ressource') !!}
        {!! html()->select('type_ressource',$types_ressources,null)->placeholder('A définir')
            ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control'])  !!}
    </div>
    <div class="col-md-4">
        {!! html()->label( 'Source','source') !!}
        {!! html()->text('source', null)->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control']) !!}
    </div>
</div>

<div class="form-group row">
    <div class="col-md-3">
        {!! html()->label( 'Montant','montant') !!}
        {!! html()->text('montant', null)->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control']) !!}
    </div>
</div>

<div class="form-group row">
    <div class="col-md-3">
        {!! html()->label( 'Date de fin','date_fin') !!}
        <div class='input-group date' id='datepicker_date_fin'>
            {!! html()->text('date_fin', null)
                ->placeholder('')
                ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control']) !!}
            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
        </div>
    </div>
</div>

<div class="form-group row">
    <div class='col-md-12'>
        {!! html()->label( 'Observations','observations') !!}
        {!! html()->textarea('observations', null)
            ->placeholder('')
            ->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control', 'rows'=>'2']) !!}
    </div>
</div>


<div class='form-group'>
    @if($mode=="show")
        @if($user->hasRole("ADMINISTRATEUR") || $user->can("RES_MAJ"))
            @if($mode_frame) 
                <a class="btn btn-primary" href="{!! url('/allocataires_maj_ressources_pop/'.$ressource->id) !!}">Modifier</a> 
            @else 
                <a class="btn btn-primary" href="{!! url('/ressources/'.$ressource->id.'/edit') !!}">Modifier</a> 
            @endif
        @endif
        @if($ressource->IsSupprimable)
            @if($mode_frame) 
                <a class="btn btn-danger" href="{!! url('/allocataires_delete_ressources_pop/'.$ressource->id) !!}">Supprimer</a> 
            @else
                {{ html()->form('DELETE', url('/ressources/'. $ressource->id))->open() }}
                    <button class="btn btn-danger" onclick="if(!confirm('Voulez-vous vraiment supprimer cette Ressource ?')) return false;">Supprimer</button>
                {{ html()->form()->close() }}
            @endif
        @endif

    @else
        {!! html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
    @endif
    @if(!$mode_frame) 
    <a class="btn btn-warning"  href="{!! url('ressources') !!}">Retour</a>
    @endif
</div>


