@extends('layouts.dash')

@section('title') Ressources @stop

@section('subtitle_card',"")
@section('content')


        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif

        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif

        @if (Session::has('success'))
            <div class="alert alert-success">{!! \Session::get('success') !!}</div>
        @endif

        <div class="card">
            <div class="card-header">
                <h3>Ressources</h3>
            </div>
            <div class="card-body">
                @if($user->can("VIL_AJO") || $user->HasRole("ADMINISTRATEUR"))
                    <div class="row">
                        <a href="{{ url('ressources/create') }}" class="btn btn-success">Ajouter une Ressource</a>
                    </div>
                @endif
                <table id="_table" class="table table-condensed table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Allocataire</th>
                            <th>Type</th>
                            <th>Montant</th>
                            <th>Source</th>
                            <th>DateFin</th>
                        </tr>
                    </thead>
        
                    <tbody>
                        @foreach ($ressources as $ressource)
                        <tr>
                            <td>
                                <a href="./ressources/{!! $ressource->id !!}">
                                {!! $ressource->NomCompletAllocataire !!}
                                </a>
                            </td>
                            <td>{!! $ressource->type_ressource !!}</td>
                            <td>{!! $ressource->montant !!}</td>
                            <td>{!! $ressource->source !!}</td> 
                            <td>{!! $ressource->DateFin !!}</td> 
                        </tr>
                        @endforeach
                    </tbody>
                </table>

            </div>
        </div>

@endsection

@section('scripts')
    @include("forms.scripts_datatable_btn")
@endsection


