<div class="row">
    <!-- DATA -->
    <div class="col-md-8">
      <div class="card">
        <div class="card-header bg-info">
            {!! $legende_data_district." - Données" !!}
        </div>
        <div class="card-body">
            <table id='_table_district' class='table table-stripped table-bordered'> 
                <thead>
                  <tr>
                    <th width='1px'>Mois</th>
                    <th>Nb Allocataires</th>
                    @foreach($t_districts as $code=>$libelle)
                        <th>{{ $libelle }}</th>
                    @endforeach
                  </tr>
                </thead>
                <tbody>
                  @foreach($statistiques as $statistique)
                  <tr class="tr_{{ $statistique->mois }}">
                    <td align='center'>{{ $statistique->mois }}</td>
                    <td align='right'>{{ $statistique->nb_allocataires }}</td>
                    @foreach($t_districts as $code=>$libelle)
                        <td align='right'>{{ isset($statistique->districts[$libelle])?$statistique->districts[$libelle]:0 }}</td>
                    @endforeach
                  </tr>
                  @endforeach
                </tbody>
            </table>
        </div>
      </div>
    </div>
    <!-- GRAPH -->
    <div class="col-md-4">
      <div class="card">
        <div class="card-header bg-warning">
            {!! $legende_data_district." - Graphique" !!}
        </div>
        <div class="card-body">
            <div class="row">
                <div class='col-md-6 offset-md-3'>
                    {!! html()->select('select_mois2',$t_mois,isset($mois_aff)?$mois_aff:"")->attributes(['class' => 'select_mois form-control','role' => 'district'])  !!}
                </div>
            </div> 
            <div class="row">
                <canvas id="pieChart_district" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
            </div> 
        </div>
      </div>
    </div>
  </div>
  