<div class="row">
    <!-- DATA -->
    <div class="col-md-6">
      <div class="card">
        <div class="card-header bg-info">
            <h3 class="card-title">{!! $legende_data_gene." - Montants versés" !!}</h3>
            <div class="card-tools" >
              <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse" >
                <i class="fas fa-minus"></i>
              </button>
          </div>
        </div>
        <div class="card-body">
            <table id='_table' class='table table-stripped table-bordered'> 
                <thead>
                  <tr>
                    <th width='1px'>Mois</th>
                    <th>NbAlloc.</th>
                    <th>MonoParent.</th>
                    <th>NbEnf.</th>
                    <th>Montant versé</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($statistiques as $statistique)
                  <tr class="">
                    <td align='center'>{{ $statistique->mois }}</td>
                    <td align='right'>{{ $statistique->nb_allocataires }}</td>
                    <td align='right'>{{ $statistique->nb_mono_parents }}</td>
                    <td align='right'>{{ $statistique->nb_enfants }}</td>
                    <td align='right'>{{ $statistique->montant }}</td>
                  </tr>
                  @endforeach
                </tbody>
            </table>
        </div>
      </div>
    </div>

    <div class="col-md-6">
      <div class="card">
        <div class="card-header bg-warning">
            <h3 class="card-title">{!! $legende_data_gene." - Graphique" !!}</h3>
            <div class="card-tools" >
              <button type="button" class="btn bg-warning btn-sm" data-card-widget="collapse" >
                <i class="fas fa-minus"></i>
              </button>
          </div>
        </div>
        <div class="card-body">
          <div class="chart">
            <canvas id="lineChart_montant" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
          </div>
        </div>
      </div>
    </div>
</div>


<!-- GRAPH ALLOCATIONS PAR MOIS-->
<div class="row">
    <div class="col-md-6">
      <div class="card">
        <div class="card-header bg-info">
            <h3 class="card-title">{!! $legende_data_gene." - Certificats" !!}</h3>
            <div class="card-tools" >
              <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse" >
                <i class="fas fa-minus"></i>
              </button>
          </div>
        </div>
        <div class="card-body">
          <div class="chart">
            <table id='_table2' class='table table-stripped table-bordered'> 
              <thead>
                <tr>
                  <th width='1px'>Mois</th>
                  <th>NbEnf.</th>
                  <th>AgeMoy</th>
                  @foreach($t_certificats as $code=>$libelle)
                      <th>Cert:{{ $code }}</th>
                  @endforeach
                </tr>
              </thead>
              <tbody>
                @foreach($statistiques as $statistique)
                <tr class="tr_{{ $statistique->mois }}">
                  <td align='center'>{{ $statistique->mois }}</td>
                  <td align='right'>{{ $statistique->nb_enfants }}</td>
                  <td align='right'>{{ $statistique->moyenne_age }}</td>
                  @foreach($t_certificats as $code=>$libelle)
                    <td align='right'>{{ isset($statistique->certificats[$code])?$statistique->certificats[$code]:0 }}</td>
                  @endforeach
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

    <div class="col-md-6">
      <div class="card">
        <div class="card-header bg-warning">
            <h3 class="card-title">{!! $legende_data_gene." - Graphique" !!}</h3>
            <div class="card-tools" >
              <button type="button" class="btn bg-warning btn-sm" data-card-widget="collapse" >
                <i class="fas fa-minus"></i>
              </button>
          </div>
        </div>
        <div class="card-body">
          <div class="row">
            <div class='col-md-6 offset-md-3'>
                {!! html()->select('select_mois0',$t_mois,isset($mois_aff)?$mois_aff:"")->attributes(['class' => 'select_mois form-control','role' => ''])  !!}
            </div>
          </div>
          <div class="row chart">
            <canvas id="pieChart_certificat_enfant" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
          </div>
        </div>
      </div>
    </div>
  </div>
  