<div class="row">
    <!-- DATA -->
    <div class="col-md-5">
      <div class="card">
        <div class="card-header bg-info"  >
            <h3 class="card-title">{!! $legende_data_ile." - Données" !!}</h3>
            <div class="card-tools" >
                <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse" >
                  <i class="fas fa-minus"></i>
                </button>
            </div>
        </div>
        <div class="card-body">
            <table id='_table_ile' class='table table-stripped table-bordered'> 
                <thead>
                  <tr>
                    <th width='1px'>Mois</th>
                    <th>Nb Allocataires</th>
                    @foreach($t_iles as $code=>$libelle)
                        <th>{{ $libelle }}</th>
                    @endforeach
                  </tr>
                </thead>
                <tbody>
                  @foreach($statistiques as $statistique)
                  <tr class="tr_{{ $statistique->mois }}">
                    <td align='center'>{{ $statistique->mois }}</td>
                    <td align='right'>{{ $statistique->nb_allocataires }}</td>
                    @foreach($t_iles as $code=>$libelle)
                        <td align='right'>{{ isset($statistique->iles[$code])?$statistique->iles[$code]:0 }}</td>
                    @endforeach
                  </tr>
                  @endforeach
                </tbody>
            </table>
        </div>
      </div>
    </div>
    <!-- GRAPH -->
    <div class="col-md-7">
      <div class="card">
        <div class="card-header bg-warning">
            <h3 class="card-title">{!! $legende_data_ile." - Graphique" !!}</h3>
            <div class="card-tools" >
                <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse">
                  <i class="fas fa-minus"></i>
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class='col-md-6 offset-md-3'>
                    {!! html()->select('select_mois',$t_mois,isset($mois_aff)?$mois_aff:"")->attributes(['class' => 'select_mois form-control','role' => 'ile'])  !!}
                </div>
            </div> 
            <div class="row">
                <canvas id="pieChart_ile" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
            </div> 
        </div>
      </div>
    </div>
  </div>
  