@extends('layouts.dash')
@section('title') Analyses @stop
@section('title_card',"")

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline card-tabs">
                <div class="card-header p-0 pt-1 border-bottom-0">
                    <ul class="nav nav-tabs" id="custom-tabs-three-tab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link {{ ($onglet=='')?'active':'' }}" id="custom-tabs-three-home-tab" data-toggle="pill" href="#custom-tabs-three-home" role="tab" aria-controls="custom-tabs-three-home" aria-selected="false">Général</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ ($onglet=='ile')?'active':'' }}" id="custom-tabs-three-ile-tab" data-toggle="pill" href="#custom-tabs-three-ile" role="tab" aria-controls="custom-tabs-three-ile" aria-selected="false">Ile</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ ($onglet=='district')?'active':'' }}" id="custom-tabs-three-district-tab" data-toggle="pill" href="#custom-tabs-three-district" role="tab" aria-controls="custom-tabs-three-district" aria-selected="false">District</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ ($onglet=='age')?'active':'' }}" id="custom-tabs-three-age-tab" data-toggle="pill" href="#custom-tabs-three-age" role="tab" aria-controls="custom-tabs-three-age" aria-selected="false">Ages</a>
                        </li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content" id="custom-tabs-three-tabContent">
                        <div class="tab-pane fade {{ ($onglet=='')?'active show':'' }}  " id="custom-tabs-three-home" role="tabpanel" aria-labelledby="custom-tabs-three-home-tab">
                            @include("stats.csr.content_home")
                        </div>
                        <div class="tab-pane fade {{ ($onglet=='ile')?'active show':'' }}" id="custom-tabs-three-ile" role="tabpanel" aria-labelledby="custom-tabs-three-ile-tab">
                            @include("stats.csr.content_ile")
                        </div>
                        <div class="tab-pane fade {{ ($onglet=='district')?'active show':'' }}" id="custom-tabs-three-district" role="tabpanel" aria-labelledby="custom-tabs-three-district-tab">
                            @include("stats.csr.content_district")
                        </div>
                        <div class="tab-pane fade {{ ($onglet=='age')?'active show':'' }}" id="custom-tabs-three-age" role="tabpanel" aria-labelledby="custom-tabs-three-age-tab">
                            @include("stats.csr.content_age")
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <!-- Graph  -->
    <script src="{{ url('js\chart.js\chart.umd.js') }}"></script>

    <script>
    $(function () {
        var mois="{{ $mois_aff }}";
        $(".tr_"+mois).css("background-color","#ffebbb");
        $(".select_mois").change(function() {
            reload($(this).val(),$(this).attr("role"));
        }) 
        function reload(mois,onglet){
            var url="{!! url('stats/tdb_csr') !!}"+"/"+mois+"/"+onglet;
            location.href=url;   
        } 
    })
    </script>
    //GRaphiques
    @include("stats.csr.scripts_graph")
    //Tables
    @include("stats.csr.scripts_datatable")
@endsection
