@extends('layouts.dash')
@section('title') Analyses @stop
@section('title_card',"")



@section('content')

<div class="row">
  <!-- DATA -->
  <div class="col-md-5">
    <div class="card">
      <div class="card-header bg-{{ App\Models\MyApp::COLOR_AIDES[$type_aide] }}">
          <h3 class="card-title">{!! App\Models\MyApp::TYPES_AIDES[$type_aide]." - Données" !!}</h3>
          <div class="card-tools" >
            <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse" >
              <i class="fas fa-minus"></i>
            </button>
        </div>
      </div>
      <div class="card-body">
        <table id='_table' class='table table-stripped table-bordered'> 
            <thead>
              <tr>
                <th width='1px'>Mois</th>
                <th>NbAllocataires</th>
                @if($type_aide=="AAE")
                  <th>NbEnfants</th>
                @endif
                <th>Montant</th>
              </tr>
            </thead>
            <tbody>
              @foreach($statistiques as $data)
              <tr>
                <td align='center'>{{ $data->mois }}</td>
                <td align='right'>{{ $data->nb_allocataires }}</td>
                @if($type_aide=="AAE")
                  <td align='right'>{{ $data->nb_enfants }}</td>
                @endif
                <td align='right'>{{ $data->montant }}</td>
              </tr>
              @endforeach
            </tbody>
        </table>
      </div>
    </div>
  </div>
  <!-- GRAPH -->
  <div class="col-md-7">
    <div class="card">
      <div class="card-header bg-{{ App\Models\MyApp::COLOR_AIDES[$type_aide] }}">
          {!! App\Models\MyApp::TYPES_AIDES[$type_aide]." - Graphique" !!}
      </div>
      <div class="card-body">
        <div class="chart"><div class="chartjs-size-monitor"><div class="chartjs-size-monitor-expand"><div class=""></div></div><div class="chartjs-size-monitor-shrink"><div class=""></div></div></div>
          <canvas id="barChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%; display: block; width: 590px;" width="472" height="200" class="chartjs-render-monitor"></canvas>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection

@section('styles')
    
@stop

@section('scripts')
    <!-- Graph  -->
    <script src="{{ url('js\chart.js\chart.umd.js') }}"></script>

  <script>
      $(function () {

        var areaChartData = {
        labels  : {!! json_encode($t_label) !!},
        datasets: [
          {
            label               : '{!! $legende_data2 !!}',
            backgroundColor     : 'rgba(60,141,188,0.9)',
            borderColor         : 'rgba(60,141,188,0.8)',
            pointRadius          : false,
            pointColor          : '#3b8bba',
            pointStrokeColor    : 'rgba(60,141,188,1)',
            pointHighlightFill  : '#fff',
            pointHighlightStroke: 'rgba(60,141,188,1)',
            data                : {!! json_encode($t_data1) !!},
            yAxisID             : 'y'
          },
          {
            label               : '{!! $legende_data1 !!}',
            backgroundColor     : 'rgba(210, 214, 222, 1)',
            borderColor         : 'rgba(210, 214, 222, 1)',
            pointRadius         : false,
            pointColor          : 'rgba(210, 214, 222, 1)',
            pointStrokeColor    : '#c1c7d1',
            pointHighlightFill  : '#fff',
            pointHighlightStroke: 'rgba(220,220,220,1)',
            data                : {!! json_encode($t_data2) !!},
            yAxisID             : 'y1'
          },


        ]
      }

      //-------------
      //- BAR CHART -
      //-------------
      var barChartCanvas = $('#barChart').get(0).getContext('2d')
      var barChartData = $.extend(true, {}, areaChartData)
      var temp0 = areaChartData.datasets[0]
      var temp1 = areaChartData.datasets[1]
      barChartData.datasets[0] = temp1
      barChartData.datasets[1] = temp0


      new Chart(barChartCanvas, {
        type: 'bar',
        data: barChartData,
        options: {
          responsive              : true,
          maintainAspectRatio     : false,
          datasetFill             : true,
          scales: {
              y: { //NbVers
                  //suggestedMin: 0,
                  //suggestedMax: 500,
                  position: 'left',
              },
              y1: {
                  //suggestedMin: 0,
                  //suggestedMax: 7000000,
                  position: 'right',
                  // grid line settings
                  grid: {
                    drawOnChartArea: false, // only want the grid lines for one axis to show up
                  },
              }
          },
        }
      })

      
    });
  </script>



@endsection
