@extends('layouts.dash')
@section('title') Allocataire @stop

@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card card-success">
        <div class="card-header">
            <h2>Allocataire <span style='color:darkblue'>{!! $allocataire->NomComplet !!}</span>
                <small><span>{!! $allocataire->IdPAD !!}</span></small></h2>
        </div>
        <div class='card-body'>
            {{ html()->modelForm($allocataire, 'PUT', url('allocataires/' . $allocataire->id))->attributes(['id'=>'allocataire'])->open() }}
                <input type="hidden" name="reload_form" id="reload_form" value="">
                @include("tiers.allocataires.content")
            {{ html()->closeModelForm() }}
        </div>
    </div>
@stop


@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop

@section('scripts')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script src="{{ url('js/magicsuggest.js') }}"></script>

    @include("tiers.allocataires.scripts_allocataires")
    @include('tiers.allocataires.scripts_allocataires_tables');
@stop
