luc.launay@gmail.com


@extends('layouts.dash')
@section('title') Allocataires @stop
@section('title_card') Allocataires @stop

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif


    <div class="card">
        <div class="card-header bg-info">
            <h2 class="card-title">{{ $title }}</h2>
        </div>
        <div class="card-body">
            <div class="row" style="padding-bottom:30px">
                <div class='col-md-2'>
                    {!! html()->label('Ile','select_ile') !!}
                    {!! html()->select('select_ile',App\Models\MyApp::ILES,isset($ile)?$ile:"")->placeholder('Toutes')
                        ->attributes(['class' => 'form-control','id' => 'select_ile'])  !!}
                </div>
                <div class='col-md-4'>
                    {!! html()->label('Aide','select_aide') !!}
                    {!! html()->select('select_aide',App\Models\MyApp::TYPES_AIDES,isset($aide)?$aide:"")->placeholder('Toutes')
                        ->attributes(['class' => 'form-control','id' => 'select_aide'])  !!}
                </div>
                <div class='col-md-4'>
                    {!! html()->label('Activité','select_actif') !!}
                    {!! html()->select('select_actif',["ACT"=>"Actifs","INA"=>"Inactifs"],isset($activite)?$activite:"")->placeholder('Toutes')
                        ->attributes(['class' => 'form-control','id' => 'select_actif'])  !!}
                </div>
                @if($user->can("ALO_AJO") || $user->HasRole("ADMINISTRATEUR"))
                    <div class="col-2">
                        {!! html()->label( '&nbsp;','') !!}<br/>
                        {!! html()->a(url('allocataires/create'),"Ajouter un allocataire")->attributes(['class' => 'btn btn-success'])  !!}
                    </div>
                @endif
            </div>  
            <table id="_table" style="background-color:white;width:100%" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th width='1px'>Id</th>
                        <th width='1px'>Famille</th>
                        <th width='1px'>CPSWF</th>
                        <th >Nom</th>
                        <th width='1px'>Naissance</th>
                        <th width='1px'>Village</th>
                        <th>Conjoint</th>
                        <th>Enfants</th>
                        <th width='1px'>NbEnfants</th>
                        <th width='1px'>Ressources</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'>Mise à jour</th>

                    </tr>
                </thead>
                <tbody>
                    @foreach ($allocataires as $allocataire)
                        <tr>
                            <td  >
                                <a class="btn btn-sm bg-secondary" href="{!! url('allocataires/'.$allocataire->id) !!}">{!! $allocataire->IdPAD !!}</a>
                                @if($allocataire->controle)<br\>
                                    <span title="A Contrôler" class="right badge badge-danger">CTL</span>
                                @endif

                            </td>
                            <td align="center">
                                @if($allocataire->id_famille)
                                    <a class="btn btn-sm bg-primary" href="{!! url('familles/'.$allocataire->id_famille) !!}">{!! $allocataire->IdPADFamille !!}</a>
                                @else
                                    <span class="badge badge-info right"> Aucun</span>
                                @endif
                                @if($allocataire->hasAide('AAE')&&(!$allocataire->IsTitulaire))
                                <span class="badge badge-danger right">Non titulaire avec<br/>Aide à l'enfant</span>
                                @endif
                            </td>
                            <td>
                                {!! $allocataire->IdCPSWFPAD !!}
                            </td>
                            <td>{!! $allocataire->nom_complet2 !!}
                                @if ($allocataire->statut_dossier!="ACT")
                                    <span class="right badge badge-danger">Inactif</span>    
                                @endif
                            </td>
                            <td align="center">{!! $allocataire->date_naissance !!}</td>
                            <td>{!! $allocataire->VillageNom."-".$allocataire->Ile !!}</td>
                            <td>{!! $allocataire->ConjointNomComplet !!}</td>
                            <td>{!! $allocataire->getEnfantsListe() !!}</td>
                            <td align="center">{!! $allocataire->getNbEnfantsLESS() !!}</td>
                            <td align="center">{!! $allocataire->MontantRessources !!}</td>
                            <td align="center">{!! $allocataire->QF !!}</td>
                            <td align="center">{!! $allocataire->statut !!}</td>
                            <td align="center" title="Création le {!! $allocataire->CreatedAt !!}">{!! $allocataire->UpdatedAt !!}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
<script>
    $(function () {
        $('#select_aide').change(function() {select_filtre();});
        $('#select_ile').change(function() {select_filtre();});
        $('#select_actif').change(function() {select_filtre();});
        
        function select_filtre() {
            var aide=$('#select_aide').val();
            if(aide=="") aide=0;
            var ile=$('#select_ile').val();
            if(ile=="") ile=0;
            var actif=$('#select_actif').val();
            if(actif=="") actif=0;
            var url="{!! url('allocataires_filtre') !!}"+"/"+ile+"/"+aide+"/"+actif;
            location.href=url;
        }
    });
</script>


<script>
  $(function () {
    $("#_table").DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "responsive": false,
      "autoWidth": true,
      "fixedHeader": true,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }

        },
        dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12't>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",
        "columnDefs": 
            [
                { "targets": [11], "orderable": true,"searchable": false, "visible": false},
            ],
        "buttons": ["copy", "excel", "colvis"] //"print", "pdf", "csv",
    })
    .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

  });
</script>
@endsection
