@extends('layouts.dash')
@section('title') Enfant @stop

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-success">{{ Session::get('message') }}</div>
        <script>
            parent.location.reload();
            parent.jQuery.fancybox.close();
        </script>
    @else
        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif
        <div class="card card-warning">
            @if($allocataire)<h2 class="card-header">Nouvelle fiche Enfant</h2>@endif
            <div class='card-body'>
                {{ html()->form('POST', url('enfants'))->open() }}
                    <input type="hidden" name="id_allocataire" value="{{ isset($allocataire)?$allocataire->id:'' }}">
                    <input type="hidden" name="mode_frame" value="{{ ((isset($allocataire)&&($allocataire))?true:false) }}">
                    @include("tiers.enfants.content")
                {{ html()->form()->close() }}
            </div>
        </div>
    @endif
@stop


@section('scripts0')
    @include('tiers.enfants.scripts_enfant')
@stop
