@extends('layouts.dash')
@section('title') Enfant @stop
@if(!$enfant)
    @section('title_card') Mise à jour d'une fiche Enfant @stop
@endif

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-success">{{ Session::get('message') }}</div>
        <script>
            parent.location.reload();
            parent.jQuery.fancybox.close();
        </script>
    @else
        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif
        <div class="card card-info">
            <div class="card-header">
                <h3 class="card-title">{!! $enfant->nom_complet !!}</h3>
            </div>
            <div class='card-body'>
                {{ html()->modelForm($enfant, 'PUT', url('enfants/' . $enfant->id))->attributes(['id'=>'enfant'])->open() }}
                    <input type="hidden" name="id_enfant" value="{{ isset($enfant)?$enfant->id:"" }}">
                    <input type="hidden" name="mode_frame" value="{{ ((isset($enfant)&&($enfant))?true:false) }}">
                    <input type="hidden" name="reload_form" id="reload_form" value="">
                    @include("tiers.enfants.content")
                {{ html()->closeModelForm() }}
            </div>
        </div>
    @endif
@stop

@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop

@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    @include('tiers.enfants.scripts_enfants')
@stop

