@extends('layouts.dash')
@section('title') Enfant @stop

@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card card-info">
        <div class="card-header">
            <h2>Enfant <span style='color:darkblue'>{!! $enfant->NomComplet !!}</span></h2>
        </div>
        <div class='card-body'>
            @if (Session::has('message'))
                <div class="alert alert-warning">{!! Session::get('message') !!}</div>
             @endif
            {{ html()->modelForm($enfant, 'PUT', url('enfants/' . $enfant->id))->open() }}
                @include("tiers.enfants.content")
            {{ html()->closeModelForm() }}
        </div>
    </div>
@stop

@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop

@section('scripts')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    @include("tiers.enfants.scripts_enfants")
@stop