@extends('layouts.dash')
@section('title') Versements @stop
@section('title_card',"")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header bg-{{ App\Models\MyApp::COLOR_AIDES[$type_aide] }}">
            {!! "Versement des ".App\Models\MyApp::TYPES_AIDES[$type_aide] !!}
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-2 mb-2">
                {!! html()->label("Numéro d'imprimé&nbsp;:&nbsp;",'brd') !!}
                {!! html()->select('num_imp')->options($liste_num_imp)
                    ->value($num_imp)
                    ->placeholder('Choisir un mois')
                    ->attributes(['id' => 'num_imp','class' => 'form-control '])  !!}
                </div>
            </div>
            @if($type_aide!="")
                <div class="row">
                    <div class="table-responsive">
                        <table id="_table" class="table table-condensed table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th width='1%'>N°</th>
                                    <th >Allocataire</th>
                                    <th >Ile</th>
                                    <th >District</th>
                                    <th >Village</th>
                                    @if($type_aide=="AAE")
                                        <th>NbEnf<br/>Soc/Tot</th>
                                    @endif
                                    <th width='1%'>Naissance</th>
                                    <th width='10%'>Banque/ModePmt</th>
                                    <th width='10%'>Titulaire</th>
                                    <th width='10%'>Compte</th>
                                    <th width='1%'>Rappel</th>
                                    <th width='1%'>Montant</th>
                                    <th width='1%'>Total</th>
                                    <th>Observations</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $nb_versements_nd=0; @endphp
                                @foreach ($versements as $versement)
                                    @php
                                        $nb_versements_nd+=(!$versement->mode_versement)?1:0;
                                    @endphp
                                    <tr>
                                        <td >
                                            <a class="btn bg-info" href="{!! url('allocataires/'.$versement->id_allocataire) !!}" >
                                                {!! $versement->AllocataireIdPAD !!}
                                            </a>
                                        </td>
                                        <td><b>{!! $versement->destinataire_nom." ".$versement->destinataire_prenom !!}</b></td>
                                        <td>{!! $versement->ile !!}</td>
                                        <td>{!! $versement->district !!}</td>
                                        <td>{!! $versement->village !!}</td>
                                        @if($type_aide=="AAE")
                                            <td>
                                                {!! $versement->AllocataireNbEnfantsAAE !!}
                                            </td>
                                        @endif
                                        <td>{!! $versement->AllocataireDateNaissance !!}</td>
                                        <td>
                                            @if($versement->mode_versement=="NUM")
                                                <span class="badge badge-warning right">NUMERAIRE{!! ($versement->procuration_nom)?" Avec procuration":"" !!}</span>
                                                @if($versement->procuration_nom)
                                                <span title="{!! $versement->procuration_motif !!}">{!! $versement->procuration_nom."&nbsp;".$versement->procuration_prenom !!}</span>
                                                @endif
                                            @endif
                                            @if($versement->mode_versement=="VIR")
                                                {!! $versement->BanqueNom !!}
                                            @endif
                                        </td>
                                        <td>
                                            <b>{!! $versement->titulaire !!}</b>
                                        </td>
                                        <td nowrap>
                                            @if($versement->mode_versement=="VIR")
                                                {!! $versement->compte !!}
                                            @endif
                                        </td>
                                        <td align="right" class="text-info"  nowrap>
                                            <b>{!! $versement->montant_r !!}</b>
                                        </td>
                                        <td align="right" class="text-primary" nowrap>
                                            <b>{!! $versement->montant !!}</b>
                                        </td>
                                        <td align="right" class="text-success" ><b>{!! $versement->montant_r+$versement->montant !!}</b></td>
                                        <td>{!! $versement->observations !!}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @endif
        </div>
        @if($type_aide!="")
            <div class="card-footer">
                 <div class="row">
                    <div class="col-md-12" >
                        <a href="{!! url('versements_export_'.strtolower($type_aide).'/'.$num_imp) !!}" class="btn btn-warning"  target="_blank">Générer le fichier DFiP</a>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 mt-3" >
                        <!-- <a href="{!! url('versements_print_'.strtolower($type_aide).'/'.$num_imp) !!}" class="btn btn-primary"  target="_blank">Imprimer&nbsp;le&nbsp;borderau</a> -->
                        <a href="{!! url('versements_print_liste_'.strtolower($type_aide).'/'.$num_imp) !!}" class="btn btn-primary"  target="_blank"><i class='fas fa-print'></i>&nbsp;Liste complète</a>
                        <a href="{!! url('versements_print_dfip_'.strtolower($type_aide).'/'.$num_imp) !!}" class="btn btn-primary"  target="_blank"><i class='fas fa-print'></i>&nbsp;Virements DFiP</a>
                        <a href="{!! url('versements_print_vrmt_'.strtolower($type_aide).'/'.$num_imp) !!}" class="btn btn-primary"  target="_blank"><i class='fas fa-print'></i>&nbsp;Virements Autres</a>
                        <a href="{!! url('versements_print_num_'.strtolower($type_aide).'/'.$num_imp) !!}" class="btn btn-primary"  target="_blank"><i class='fas fa-print'></i>&nbsp;Liste Numéraires</a>
                        <a href="{!! url('versements_print_emargement_'.strtolower($type_aide).'/'.$num_imp.'/W') !!}" class="btn btn-primary"  target="_blank"><i class='fas fa-print'></i>&nbsp;Emargement Wallis</a>
                        <a href="{!! url('versements_print_emargement_'.strtolower($type_aide).'/'.$num_imp.'/F') !!}" class="btn btn-primary"  target="_blank"><i class='fas fa-print'></i>&nbsp;Emargement Futuna</a>
                        @if($deletable)
                        <a onclick="if(!confirm('Voulez-vous vraiment supprimer ce versement ?')) return false;" href="{!! url('versements_delete/'.strtolower($type_aide).'/'.$num_imp) !!}" class="btn btn-danger"><i class='fas fa-print'></i>&nbsp;Suppression du versement</a>
                        @endif
                    </div>
                </div>
            </div>
        @endif
    </div>
@endsection


@section('scripts0')
<script>
    $(function () {
        $("#num_imp").change(function() {
            reload();
        }) 
        function reload(){
            var num_imp=$('#num_imp').val();
            if(num_imp=="") aide=0;
            var url="{!! url('versements_aae') !!}"+"/"+num_imp;
            location.href=url;   
        } 
    })
    </script>
    @include('forms.scripts_datatable_btn')
@endsection


