@extends('layouts.dash')
@section('title') Versements @stop
@section('title_card',"Versements")
@section('subtitle_card',"")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif


    <div class="card">
        <div class="card-header bg-{{ App\Models\MyApp::COLOR_AIDES[$type_aide] }}">
            {!! "Versement en préparation pour : ".$title !!}
        </div>
        <div class="card-body">
            @if(count($versements_prepas)>0)
                <div class='row form-group'>
                    <div class="table-responsive">
                        <table id="_table" class="table table-condensed table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th width='1%'>N°</th>
                                    <th >Allocataire</th>
                                    <th width='1%'>Naissance</th>
                                    <th >Ile</th>
                                    <th >District</th>
                                    <th >Village</th>
                                    @if($type_aide=="AAE")
                                    <th>NbEnf<br/>Soc/Tot</th>
                                    @endif
                                    @if($type_aide=="PAN")
                                    <th>Enfants</th>
                                    @endif
                                    @if($type_aide=="FSO")
                                        <th>NbPers</th>
                                        <th>QF</th>
                                    @endif
                                    <th width='10%'>Banque/ModePmt</th>
                                    <th width='10%'>Titulaire</th>
                                    <th width='10%'>Compte</th>
                                    <th width='1%'>Rappel</th>
                                    <th width='1%'>Montant</th>
                                    <th width='1%'>Total</th>
                                    <th>Observations</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $nb_versements_nd=0; $nb_montant_null=0; @endphp
                                @foreach ($versements_prepas as $versement_prepa)
                                @php
                                    $nb_versements_nd+=(!$versement_prepa->mode_versement)?1:0;
                                    $nb_montant_null+=($versement_prepa->montant+$versement_prepa->montant_r==0)?1:0;
                                @endphp
                                    <tr>
                                        <td><a class="btn bg-info" href="{!! url('allocataires/'.$versement_prepa->id_allocataire) !!}" >{!! $versement_prepa->AllocataireIdPAD !!}</a></td>
                                        <td>
                                            <b>{!! $versement_prepa->destinataire_nom." ".$versement_prepa->destinataire_prenom !!}</b>
                                            @if(($type_aide=="AAE")||($type_aide=="PAN"))
                                                @if((!$versement_prepa->IsTitulaire))
                                                    <span class="badge badge-danger right"> Non titulaire avec une {{ App\Models\MyApp::TYPES_AIDES[$type_aide] }}</span>
                                                @endif
                                            @endif
                                        </td>
                                        <td>{!! $versement_prepa->AllocataireDateNaissance !!}</td>
                                        <td>{!! $versement_prepa->ile !!}</td>
                                        <td>{!! $versement_prepa->district !!}</td>
                                        <td>{!! $versement_prepa->village !!}</td>
                                        @if($type_aide=="AAE")
                                            <td>{!! $versement_prepa->nb_enf !!}</td>
                                        @endif
                                        @if($type_aide=="PAN")
                                            <td nowrap>{!! $versement_prepa->getEnfantsPANListe() !!}</td>
                                        @endif
                                        @if($type_aide=="FSO")
                                            <td nowrap>{!! $versement_prepa->nbpers_foyer !!}</td>
                                            <td nowrap>{!! $versement_prepa->qf !!}</td>
                                        @endif
                                        <td>
                                            @if($versement_prepa->mode_versement=="NUM")
                                                <span class="badge badge-warning right">NUMERAIRE{!! ($versement_prepa->procuration_nom)?" Avec procuration":"" !!}</span>
                                                @if($versement_prepa->procuration_nom)
                                                <span title="{!! $versement_prepa->procuration_motif !!}">{!! $versement_prepa->procuration_nom."&nbsp;".$versement_prepa->procuration_prenom !!}</span>
                                                @endif
                                            @endif
                                            @if($versement_prepa->mode_versement=="VIR")
                                                {!! $versement_prepa->BanqueNom !!}
                                            @endif
                                            @if(!$versement_prepa->mode_versement)
                                                <span class="badge badge-danger right">AUCUN</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($versement_prepa->mode_versement=="VIR")
                                                {!! $versement_prepa->titulaire !!}
                                            @endif
                                        </td>
                                        <td nowrap>
                                            @if($versement_prepa->mode_versement=="VIR")
                                                {!! $versement_prepa->compte !!}
                                            @endif
                                        </td>
                                        <td align="right" class="text-info"  nowrap><b>{!! $versement_prepa->montant_r !!}</b></td>
                                        <td align="right" class="text-primary" nowrap><b>{!! $versement_prepa->montant !!}</b></td>
                                        <td align="right" class="text-success" ><b>{!! $versement_prepa->montant_r+$versement_prepa->montant !!}</b></td>
                                        <td>{!! $versement_prepa->observations !!}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @else
                <h4>Aucun fichier en préparation pour ce mois</h4></br>
                <div>
                    <a href="{!! url('versements_prepa_validation_'.strtolower($type_aide)) !!}" class="btn btn-success" >Générer le fichier de versement</a>
                </div>
            @endif


            @if(count($versements_prepas)>0)
                <div class='row form-group'>
                    <div class="col-md-12">
                        @if($user->hasRole("ADMINISTRATEUR") || $user->can("VER_".$type_aide."_VAL"))
                            @if(($nb_versements_nd==0)&&($nb_montant_null==0))
                                <a href="{!! url('versements_generation_def_'.strtolower($type_aide)) !!}" 
                                    onclick="javascript:if(!confirm('Voulez-vous vraiment générer les lignes de versement définitivement ?')) return false;" 
                                    class="btn btn-success" >Génération définitive du versement</a>                                                
                            @else
                                <ul class="text-danger">
                                    @if($nb_versements_nd>0)
                                    <li>Définir les modes de versements de <b>{{ $nb_versements_nd }}</b> allocataire{{ ($nb_versements_nd==1)?'':'s' }} pour pouvoir valider</li>
                                    @endif
                                    @if($nb_montant_null>0)
                                    <li><b>{{ $nb_montant_null }}</b> bénéficiaires ont un montant à verser nul, ils ne doivent donc pas bénéficier de cette aide</li>
                                    @endif
                                </ul>
                                <button class="btn btn-success" disabled>Génération définitive du versement</button>
                            @endif
                        @endif
                        @if($user->hasRole("ADMINISTRATEUR") || $user->can("VER_".$type_aide."_PRP"))
                            <a href="{!! url('versements_prepa_validation_'.strtolower($type_aide)) !!}" 
                                onclick="javascript:if(!confirm('Voulez-vous vraiment re-générer les lignes de versement ci-dessous à partir des données Allocataire ?')) return false;" 
                                class="btn btn-warning" >Re-Générer la liste</a>
                        @endif
                    </div>
                </div>
            @endif

        </div>
@endsection

@section('styles')

@stop


@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script src="{{ url('js/magicsuggest.js') }}"></script>

    <script>
      $(function () {
        $("#_table").DataTable({
            "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "responsive": false,
      "autoWidth": false,
      "fixedHeader": true,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }

        },
            dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",
            "buttons": ["copy", "excel", "colvis"], //"print", "pdf", "csv",
        })
        .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

      });
    </script>


    <script>
        $("._box").fancybox({
            //fitToView   : true,
            width       : '85%',
            height      : '85%',
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
        });
    </script>
@endsection
