@extends('layouts.dash')
@section('title') Versements @stop
@section('title_card',"Versements")
@section('subtitle_card',"")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif


    <div class="card">
        <div class="card-header bg-{{ App\Models\MyApp::COLOR_AIDES[$type_aide] }}">
            {!! "Versement en préparation pour : ".$title !!}
        </div>
        <div class="card-body">
            @if($nb_versements_nd>0)
            <p class="text-danger">
                Pour valider le versement il faut définir tous les modes de versement.
            </p>
            @endif
            <div class='row form-group'>
                <div class="table-responsive">
                    <table id="_table" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1%'>N°</th>
                                <th >Allocataire</th>
                                <th width='1%'>Naissance</th>
                                <th >Ile</th>
                                <th >District</th>
                                <th >Village</th>
                                @if($type_aide=="AAE")
                                <th>NbEnf<br/>Soc/Tot</th>
                                @endif
                                @if($type_aide=="FSO")
                                    <th>NbPers</th>
                                    <th>QF</th>
                                @endif
                                <th width='10%'>Banque/ModePmt</th>
                                <th width='10%'>Titulaire</th>
                                <th width='10%'>Compte</th>
                                <th width='1%'>Rappel</th>
                                <th width='1%'>Montant</th>
                                <th width='1%'>Total</th>
                                <th>Observations</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($versements_prepas as $versement_prepa)
                            @php
                                $allocataire=$versement_prepa->id_allocataire;
                            @endphp
                                <tr>
                                    <td ><a class="btn bg-info" href="{!! url('allocataires/'.$allocataire->id) !!}" >{!! $allocataire->IdPAD !!}</a></td>
                                    <td><b>{!! $allocataire->NomComplet !!}</b></td>
                                    <td>{!! $allocataire->date_naissance !!}</td>
                                    <td>{!! $versement->ile !!}</td>
                                    <td>{!! $versement->district !!}</td>
                                    <td>{!! $versement->village !!}</td>
                                    @if($type_aide=="AAE")
                                        <td>{!! $allocataire->NbEnfantsAAE."/".$allocataire->NbEnfants !!}</td>
                                    @endif
                                    @if($type_aide=="FSO")
                                        <td nowrap>{!! $versement_prepa->nbpers_foyer !!}</td>
                                        <td nowrap>{!! $versement_prepa->qf !!}</td>
                                    @endif
                                    <td>
                                        @if($versement_prepa->mode_versement=="NUM")
                                            <span class="badge badge-warning right">NUMERAIRE</span>
                                        @endif
                                        @if($versement_prepa->mode_versement=="VIR")
                                            {!! $versement_prepa->BanqueNom !!}
                                        @endif
                                        @if(!$versement_prepa->mode_versement)
                                            <span class="badge badge-danger right">AUCUN</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($versement_prepa->mode_versement=="VIR")
                                            {!! $versement_prepa->titulaire !!}
                                        @endif
                                    </td>
                                    <td nowrap>
                                        @if($versement_prepa->mode_versement=="VIR")
                                            {!! $versement_prepa->compte !!}
                                        @endif
                                    </td>
                                    <td align="right" class="text-info"  nowrap><b>{!! $versement_prepa->montant_r !!}</b></td>
                                    <td align="right" class="text-primary" nowrap><b>{!! $versement_prepa->montant !!}</b></td>
                                    <td align="right" class="text-success" ><b>{!! $versement_prepa->montant_r+$versement_prepa->montant !!}</b></td>
                                    <td>{!! $versement_prepa->observations !!}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            @if($user->hasRole("ADMINISTRATEUR") || $user->can("VER_PRP"))
                <div class='row form-group'>
                    <div class="col-md-12">
                        @if($nb_versements_nd==0)
                            <a href="{!! url('versements_prepa_validation_'.strtolower($type_aide)) !!}" class="btn btn-success"  target="_blank">Valider pour préparer le bordereau</a>
                        @else
                            <button class="btn btn-success" disabled>Définir les modes de versements pour pouvoir valider</a>
                        @endif
                    </div>
                </div>
            @endif

        </div>
@endsection

@section('styles')

@stop


@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script src="{{ url('js/magicsuggest.js') }}"></script>

    <script>
      $(function () {
        $("#_table").DataTable({
            "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "responsive": false,
      "autoWidth": false,
      "fixedHeader": true,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }

        },
            dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",
            "buttons": ["copy", "excel", "colvis"], //"print", "pdf", "csv",
        })
        .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

      });
    </script>


    <script>
        $("._box").fancybox({
            //fitToView   : true,
            width       : '85%',
            height      : '85%',
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
        });
    </script>
@endsection
