

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-danger"><?php echo e(Session::get('message')); ?></div>
        <script>
            parent.location.reload();
            parent.jQuery.fancybox.close();
        </script>
    <?php else: ?>
        <?php if($errors): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class='bg-danger alert'><?php echo $error; ?></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        <div class="card">
            <div class="card-header bg-warning">
                <h2 class="card-title">Remplacer le titulaire de la famille</h2>
            </div>
            <div class='card-body'>
                <?php echo e(html()->form('POST', url('famille_replace_titulaire/'.$famille->id ))->open()); ?>

                    <input type="hidden" name="id_famille" value="<?php echo e($famille->id); ?>">
                    <input type="hidden" name="id_titulaire" id="id_titulaire" value="">

                    <div class='form-group row'>
                        <div class="col-md-12">
                            <?php echo html()->text('nom', null)
                            ->placeholder('Rechercher...')
                            ->attributes(['id'=>'nom_find', 'class' => 'form-control text-uppercase']); ?>

                        </div>
                    </div>
                    <div class='form-group row'>
                        <div class="col-md-2">
                            <?php echo html()->button('Sélectionner')->value('Sélectionner')->type('submit')->attributes(['id'=>'btn_selection','class' => 'btn btn-success']); ?>

                            <?php echo html()->a(url(''),"Nouveau")->attributes(['id'=>'btn_nouveau','class' => 'btn btn-warning']); ?>

                        </div>
                    </div>


                <?php echo e(html()->form()->close()); ?>

            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts0'); ?>
    <script type="text/javascript">
        $('#btn_selection').hide();
        $('#btn_nouveau').hide();
        //Saisie conjoint
        $("#nom_find").autocomplete({
            source: "<?php echo url('auto_famille_membre'); ?>",
            minLength: 2,
            autofocus:true,
            select: function(event, ui) {
                var id=ui.item.id;
                var idPAD=id.toString().padStart(5,"0");
                $('#id_titulaire').val(id);
                if(id) {
                    $('#btn_selection').show();
                    $('#btn_nouveau').hide();
                }
                else {
                    $('#btn_selection').hide();
                    $('#btn_nouveau').show();
                }
            },
            change: function( event, ui ) {
            }
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash_pop', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sigal/resources/views/familles/replace_titulaire_pop.blade.php ENDPATH**/ ?>