<div class="form-group row">
    <?php if($conjoint): ?>
        <div class="col-md-3 text-secondary">
            <?php echo html()->label( 'Montant Retraite du conjoint CPSWF','montant_retraite_conjoint'); ?>

            <div class="input-group mb-3">
                <?php echo html()->text('montant_retraite_conjoint', $allocataire->RetraiteConjoint)->attributes(['disabled', 'class' => 'text-success text-right form-control']); ?>

                <div class="input-group-append">
                    <span class="input-group-text ">CFP</span>
                </div>
            </div>
        </div>
        <div class="col-md-9 text-secondary">
            <h6>Dernière mise à jour de la fiche conjoint CPSWF : <?php echo e($conjoint->UpdatedAt); ?></h6>
        </div>
    <?php else: ?>
        <div class="col-md-9 text-secondary">
            <h6>Aucun conjoint</h6>
        </div>
    <?php endif; ?>
</div>

<div class="form-group row">
    <div class="col-md-2">
        <?php echo html()->label( "Date d'ouverture",'date_ouverture_csr'); ?>

        <div class='input-group date' id='datepicker_date_ouverture_csr'>
            <?php echo html()->text('date_ouverture_csr', null)
                ->placeholder('')
                ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control']); ?>

            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
        </div>
    </div>
    <div class="col-md-2">
        <?php echo html()->label( "Date de fermeture",'date_fermeture_csr'); ?>

        <div class='input-group date' id='datepicker_date_fermeture_csr'>
            <?php echo html()->text('date_fermeture_csr', null)
                ->placeholder('')
                ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control']); ?>

            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
        </div>
    </div>
    <div class="col-md-8">
        <?php echo html()->label('Motif de fermeture','fermeture_csr_motif',); ?>

        <?php echo html()->textarea('fermeture_csr_motif', null)->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control', 'rows'=>'2']); ?>

    </div>
</div>

<div class="form-group row">
    <div class="col-md-3 text-success">
        <?php echo html()->label('Montant CSR','montant_csr'); ?>

        <div class="input-group mb-3">
            <?php echo html()->text('montant_csr', null)->placeholder('Montant')->attributes(['id' => 'montant_csr',($mode=="show"?'disabled':''), 'class' => 'text-success text-right form-control']); ?>

            <div class="input-group-append">
                <span class="input-group-text ">CFP</span>
            </div>
        </div>
    </div>
    <div class="col-md-3 text-danger">
        <?php echo html()->label( 'Montants rappel','rappel_csr'); ?>

        <div class="input-group mb-3">
            <?php echo html()->text('rappel_csr', null)->placeholder('Montant rappel')->attributes(['id' => 'rappel_csr',($mode=="show"?'disabled':''), 'class' => 'text-danger text-right form-control']); ?>

            <div class="input-group-append">
                <span class="input-group-text">CFP</span>
            </div>
        </div>
    </div>
    <div class="col-md-3 text-danger">
        <?php echo html()->label( 'Total à verser','total_csr'); ?>

        <div class="input-group mb-3">
            <?php echo html()->text('total_csr', null)->attributes(['id' => 'total_csr','disabled', 'class' => 'text-danger text-right form-control']); ?>

            <div class="input-group-append">
                <span class="input-group-text">CFP</span>
            </div>
        </div>
    </div>
</div>

<div class="form-group row">
    <div class="col-md-12">
        <?php echo html()->label('Observations destinées au prochain versement','obs_csr',); ?>

        <?php echo html()->textarea('obs_csr', null)->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control', 'rows'=>'3']); ?>

    </div>
</div>

<div class="form-group row">
    <div class="col-md-12">
        <?php if($allocataire->getLastVersement("CSR")): ?>
            <a href="<?php echo url('attestation_pmt/CSR/'.$allocataire->id); ?>" 
                style="text-decoration:none;color:white" class="btn btn-primary"  target="_blank"><i class='fas fa-print'></i>&nbsp;Attestation de paiement</a>
        <?php else: ?>
            <p class="text-danger">Aucun versement encore effectué</p>
        <?php endif; ?>
    </div>
</div>


<div class="form-group row">
    <div class="col-md-12">
        <?php echo html()->label('Historique des versements CSR','obs_csr',); ?>

        <table id="_table_versements_csr" class="table table-condensed table-stripped">
            <thead>
                <tr>
                    <th>Id</th>
                    <th>N°Imp</th>
                    <th>Date</th>
                    <th>Montant Rappel</th>
                    <th>Montant</th>
                    <th>Total</th>
                    <th>Observations</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $versements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $versement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($versement->type=="CSR"): ?>
                        <tr>
                            <td><?php echo e($versement->IdPAD); ?></td>
                            <td><?php echo e($versement->NumImpPAD); ?></td>
                            <td><?php echo e($versement->date); ?></td>
                            <td><?php echo e($versement->montant_r); ?></td>
                            <td><?php echo e($versement->montant); ?></td>
                            <td><?php echo e($versement->montant_r+$versement->montant); ?></td>
                            <td><?php echo e($versement->observations); ?></td>
                        </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>





<?php /**PATH /var/www/html/sigal/resources/views/tiers/allocataires/rows_aides_csr.blade.php ENDPATH**/ ?>