
<?php $__env->startSection('title'); ?> Versements <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',"Versements"); ?>
<?php $__env->startSection('subtitle_card',""); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>


    <div class="card">
        <div class="card-header bg-<?php echo e(App\Models\MyApp::COLOR_AIDES[$type_aide]); ?>">
            <?php echo "Versement en préparation pour : ".$title; ?>

        </div>
        <div class="card-body">
            <?php if(count($versements_prepas)>0): ?>
                <div class='row form-group'>
                    <div class="table-responsive">
                        <table id="_table" class="table table-condensed table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th width='1%'>N°</th>
                                    <th >Allocataire</th>
                                    <th width='1%'>Naissance</th>
                                    <th >Ile</th>
                                    <th >District</th>
                                    <th >Village</th>
                                    <?php if($type_aide=="AAE"): ?>
                                    <th>NbEnf<br/>Soc/Tot</th>
                                    <?php endif; ?>
                                    <?php if($type_aide=="PAN"): ?>
                                    <th>Enfants</th>
                                    <?php endif; ?>
                                    <?php if($type_aide=="FSO"): ?>
                                        <th>NbPers</th>
                                        <th>QF</th>
                                    <?php endif; ?>
                                    <th width='10%'>Banque/ModePmt</th>
                                    <th width='10%'>Titulaire</th>
                                    <th width='10%'>Compte</th>
                                    <th width='1%'>Rappel</th>
                                    <th width='1%'>Montant</th>
                                    <th width='1%'>Total</th>
                                    <th>Observations</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $nb_versements_nd=0; $nb_montant_null=0; ?>
                                <?php $__currentLoopData = $versements_prepas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $versement_prepa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $nb_versements_nd+=(!$versement_prepa->mode_versement)?1:0;
                                    $nb_montant_null+=($versement_prepa->montant+$versement_prepa->montant_r==0)?1:0;
                                ?>
                                    <tr>
                                        <td><a class="btn bg-info" href="<?php echo url('allocataires/'.$versement_prepa->id_allocataire); ?>" ><?php echo $versement_prepa->AllocataireIdPAD; ?></a></td>
                                        <td>
                                            <b><?php echo $versement_prepa->destinataire_nom." ".$versement_prepa->destinataire_prenom; ?></b>
                                            <?php if(($type_aide=="AAE")||($type_aide=="PAN")): ?>
                                                <?php if((!$versement_prepa->IsTitulaire)): ?>
                                                    <span class="badge badge-danger right"> Non titulaire avec une <?php echo e(App\Models\MyApp::TYPES_AIDES[$type_aide]); ?></span>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo $versement_prepa->AllocataireDateNaissance; ?></td>
                                        <td><?php echo $versement_prepa->ile; ?></td>
                                        <td><?php echo $versement_prepa->district; ?></td>
                                        <td><?php echo $versement_prepa->village; ?></td>
                                        <?php if($type_aide=="AAE"): ?>
                                            <td><?php echo $versement_prepa->nb_enf; ?></td>
                                        <?php endif; ?>
                                        <?php if($type_aide=="PAN"): ?>
                                            <td nowrap><?php echo $versement_prepa->getEnfantsPANListe(); ?></td>
                                        <?php endif; ?>
                                        <?php if($type_aide=="FSO"): ?>
                                            <td nowrap><?php echo $versement_prepa->nbpers_foyer; ?></td>
                                            <td nowrap><?php echo $versement_prepa->qf; ?></td>
                                        <?php endif; ?>
                                        <td>
                                            <?php if($versement_prepa->mode_versement=="NUM"): ?>
                                                <span class="badge badge-warning right">NUMERAIRE<?php echo ($versement_prepa->procuration_nom)?" Avec procuration":""; ?></span>
                                                <?php if($versement_prepa->procuration_nom): ?>
                                                <span title="<?php echo $versement_prepa->procuration_motif; ?>"><?php echo $versement_prepa->procuration_nom."&nbsp;".$versement_prepa->procuration_prenom; ?></span>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if($versement_prepa->mode_versement=="VIR"): ?>
                                                <?php echo $versement_prepa->BanqueNom; ?>

                                            <?php endif; ?>
                                            <?php if(!$versement_prepa->mode_versement): ?>
                                                <span class="badge badge-danger right">AUCUN</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($versement_prepa->mode_versement=="VIR"): ?>
                                                <?php echo $versement_prepa->titulaire; ?>

                                            <?php endif; ?>
                                        </td>
                                        <td nowrap>
                                            <?php if($versement_prepa->mode_versement=="VIR"): ?>
                                                <?php echo $versement_prepa->compte; ?>

                                            <?php endif; ?>
                                        </td>
                                        <td align="right" class="text-info"  nowrap><b><?php echo $versement_prepa->montant_r; ?></b></td>
                                        <td align="right" class="text-primary" nowrap><b><?php echo $versement_prepa->montant; ?></b></td>
                                        <td align="right" class="text-success" ><b><?php echo $versement_prepa->montant_r+$versement_prepa->montant; ?></b></td>
                                        <td><?php echo $versement_prepa->observations; ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php else: ?>
                <h4>Aucun fichier en préparation pour ce mois</h4></br>
                <div>
                    <a href="<?php echo url('versements_prepa_validation_'.strtolower($type_aide)); ?>" class="btn btn-success" >Générer le fichier de versement</a>
                </div>
            <?php endif; ?>


            <?php if(count($versements_prepas)>0): ?>
                <div class='row form-group'>
                    <div class="col-md-12">
                        <?php if($user->hasRole("ADMINISTRATEUR") || $user->can("VER_".$type_aide."_VAL")): ?>
                            <?php if(($nb_versements_nd==0)&&($nb_montant_null==0)): ?>
                                <a href="<?php echo url('versements_generation_def_'.strtolower($type_aide)); ?>" 
                                    onclick="javascript:if(!confirm('Voulez-vous vraiment générer les lignes de versement définitivement ?')) return false;" 
                                    class="btn btn-success" >Génération définitive du versement</a>                                                
                            <?php else: ?>
                                <ul class="text-danger">
                                    <?php if($nb_versements_nd>0): ?>
                                    <li>Définir les modes de versements de <b><?php echo e($nb_versements_nd); ?></b> allocataire<?php echo e(($nb_versements_nd==1)?'':'s'); ?> pour pouvoir valider</li>
                                    <?php endif; ?>
                                    <?php if($nb_montant_null>0): ?>
                                    <li><b><?php echo e($nb_montant_null); ?></b> bénéficiaires ont un montant à verser nul, ils ne doivent donc pas bénéficier de cette aide</li>
                                    <?php endif; ?>
                                </ul>
                                <button class="btn btn-success" disabled>Génération définitive du versement</button>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php if($user->hasRole("ADMINISTRATEUR") || $user->can("VER_".$type_aide."_PRP")): ?>
                            <a href="<?php echo url('versements_prepa_validation_'.strtolower($type_aide)); ?>" 
                                onclick="javascript:if(!confirm('Voulez-vous vraiment re-générer les lignes de versement ci-dessous à partir des données Allocataire ?')) return false;" 
                                class="btn btn-warning" >Re-Générer la liste</a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>

        </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts0'); ?>
    <script src="<?php echo e(url('js/jquery.fancybox.js')); ?>"></script>
    <script src="<?php echo e(url('js/magicsuggest.js')); ?>"></script>

    <script>
      $(function () {
        $("#_table").DataTable({
            "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "responsive": false,
      "autoWidth": false,
      "fixedHeader": true,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }

        },
            dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",
            "buttons": ["copy", "excel", "colvis"], //"print", "pdf", "csv",
        })
        .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

      });
    </script>


    <script>
        $("._box").fancybox({
            //fitToView   : true,
            width       : '85%',
            height      : '85%',
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sigal/resources/views/versements/prepa/index_prepa.blade.php ENDPATH**/ ?>