
<?php $__env->startSection('title'); ?> Analyses <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',""); ?>



<?php $__env->startSection('content'); ?>

<div class="row">
  <!-- DATA -->
  <div class="col-md-5">
    <div class="card">
      <div class="card-header bg-<?php echo e(App\Models\MyApp::COLOR_AIDES[$type_aide]); ?>">
          <h3 class="card-title"><?php echo App\Models\MyApp::TYPES_AIDES[$type_aide]." - Données"; ?></h3>
          <div class="card-tools" >
            <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse" >
              <i class="fas fa-minus"></i>
            </button>
        </div>
      </div>
      <div class="card-body">
        <table id='_table' class='table table-stripped table-bordered'> 
            <thead>
              <tr>
                <th width='1px'>Mois</th>
                <th>NbAllocataires</th>
                <?php if($type_aide=="AAE"): ?>
                  <th>NbEnfants</th>
                <?php endif; ?>
                <th>Montant</th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $statistiques; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td align='center'><?php echo e($data->mois); ?></td>
                <td align='right'><?php echo e($data->nb_allocataires); ?></td>
                <?php if($type_aide=="AAE"): ?>
                  <td align='right'><?php echo e($data->nb_enfants); ?></td>
                <?php endif; ?>
                <td align='right'><?php echo e($data->montant); ?></td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
      </div>
    </div>
  </div>
  <!-- GRAPH -->
  <div class="col-md-7">
    <div class="card">
      <div class="card-header bg-<?php echo e(App\Models\MyApp::COLOR_AIDES[$type_aide]); ?>">
          <?php echo App\Models\MyApp::TYPES_AIDES[$type_aide]." - Graphique"; ?>

      </div>
      <div class="card-body">
        <div class="chart"><div class="chartjs-size-monitor"><div class="chartjs-size-monitor-expand"><div class=""></div></div><div class="chartjs-size-monitor-shrink"><div class=""></div></div></div>
          <canvas id="barChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%; display: block; width: 590px;" width="472" height="200" class="chartjs-render-monitor"></canvas>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <!-- Graph  -->
    <script src="<?php echo e(url('js\chart.js\chart.umd.js')); ?>"></script>

  <script>
      $(function () {

        var areaChartData = {
        labels  : <?php echo json_encode($t_label); ?>,
        datasets: [
          {
            label               : '<?php echo $legende_data2; ?>',
            backgroundColor     : 'rgba(60,141,188,0.9)',
            borderColor         : 'rgba(60,141,188,0.8)',
            pointRadius          : false,
            pointColor          : '#3b8bba',
            pointStrokeColor    : 'rgba(60,141,188,1)',
            pointHighlightFill  : '#fff',
            pointHighlightStroke: 'rgba(60,141,188,1)',
            data                : <?php echo json_encode($t_data1); ?>,
            yAxisID             : 'y'
          },
          {
            label               : '<?php echo $legende_data1; ?>',
            backgroundColor     : 'rgba(210, 214, 222, 1)',
            borderColor         : 'rgba(210, 214, 222, 1)',
            pointRadius         : false,
            pointColor          : 'rgba(210, 214, 222, 1)',
            pointStrokeColor    : '#c1c7d1',
            pointHighlightFill  : '#fff',
            pointHighlightStroke: 'rgba(220,220,220,1)',
            data                : <?php echo json_encode($t_data2); ?>,
            yAxisID             : 'y1'
          },


        ]
      }

      //-------------
      //- BAR CHART -
      //-------------
      var barChartCanvas = $('#barChart').get(0).getContext('2d')
      var barChartData = $.extend(true, {}, areaChartData)
      var temp0 = areaChartData.datasets[0]
      var temp1 = areaChartData.datasets[1]
      barChartData.datasets[0] = temp1
      barChartData.datasets[1] = temp0


      new Chart(barChartCanvas, {
        type: 'bar',
        data: barChartData,
        options: {
          responsive              : true,
          maintainAspectRatio     : false,
          datasetFill             : true,
          scales: {
              y: { //NbVers
                  //suggestedMin: 0,
                  //suggestedMax: 500,
                  position: 'left',
              },
              y1: {
                  //suggestedMin: 0,
                  //suggestedMax: 7000000,
                  position: 'right',
                  // grid line settings
                  grid: {
                    drawOnChartArea: false, // only want the grid lines for one axis to show up
                  },
              }
          },
        }
      })

      
    });
  </script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sigal/resources/views/stats/index_data.blade.php ENDPATH**/ ?>