<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;

use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use App\Http\Requests\BeneficiairesRequest;
use Request;
use Response;
use App\Models\Parametre;
use App\Http\Controllers\Logs;


class BeneficiairesController extends Controller {

    private $menu='beneficiaires';
    private $submenu='beneficiairess';
    private $menu_home="prime_naissance";


    public function index($type="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );


        $title="";
        $beneficiaires = Beneficiaire::orderBy('nom')->orderBy('prenom')->get();

        if(($type=strtoupper($type))=="PAN") $title=MyApp::TYPES_AIDES[$type];
        $liste_aides=MyAPP::getListeAides();
        return View::make('tiers.beneficiaires.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'title' => $title,'type' => $type,
            'beneficiaires' => $beneficiaires,'liste_aides' => $liste_aides,
        ]);
    }

    public function create($type="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $mode="create";
        $onglet_actif="o_general";
        if(($type=strtoupper($type))=="PAN") $title=MyApp::TYPES_AIDES[$type];
        $liste_statut=MyApp::BENEF_STATUTS;
        $t_roles_pop=MyApp::getRolesPop();
        $data_roles_json=json_encode($t_roles_pop);


        return View::make('tiers.beneficiaires.create', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,
            'onglet_actif' => $onglet_actif,'title' => $title,'type' => $type,
            'liste_statut' => $liste_statut,'data_roles_json' => $data_roles_json,
            
        ]);
    }

    public function store(BeneficiairesRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $beneficiaire = $this->setData($request);

        if($request->benef_type!="")  return Redirect::to('beneficiaires_liste/'.$request->benef_type);
        return Redirect::to('/beneficiaires/beneficiaires');
    }


    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $beneficiaire = Beneficiaires::find($id);

        return View::make('beneficiaires.beneficiaires.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,
            'beneficiaire' => $beneficiaire ,
            ]);
    }


    public function update($id,BeneficiairesRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $beneficiaire = $this->setData($request,$id);
        return Redirect::to('beneficiaires_liste/'.$request->benef_type);
    }


    public function show($id)
    {

    }

    public function destroy($id,$benef_type="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $beneficiaire=Beneficiaires::find($id);

        if(!$beneficiaire->IsSupprimable) {
            $msg="Suppression interdite";
            Session::flash('message', $msg);
            return Redirect::back()->with('msg', $msg);
        }
         //LOG de la transaction
        $beneficiaire=Beneficiaires::find($id);
        $beneficiaire->log_transaction('','D');

        Beneficiaires::destroy($id);
        return Redirect::to('beneficiaires_liste/'.$benef_type);
    }

    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $beneficiaire =  new Beneficiaires;
        else $beneficiaire = Beneficiaires::find($id);

        $beneficiaire->id_cpswf = $request->id_cpswf;
        $beneficiaire->type = $request->type;
        $date=$request->date_pi;
        $beneficiaire->date_pi = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $beneficiaire->nom  = strtoupper($request->nom);
        $beneficiaire->prenom  = $request->prenom;
        $beneficiaire->civilite = $request->civilite;
        $date=$request->datenaiss;
        $beneficiaire->datenaiss = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $beneficiaire->lieunaiss = $request->lieunaiss;
        $beneficiaire->adresse = $request->adresse;
        $beneficiaire->code_postal = $request->code_postal;
        $beneficiaire->district = $request->district;
        $beneficiaire->ile = $request->ile;
        $beneficiaire->mobile = $request->mobile;
        $beneficiaire->tel = $request->tel;
        $beneficiaire->email = $request->email;
        $beneficiaire->conjoint = $request->conjoint;
        $beneficiaire->quot_fam = $request->quot_fam;
        $beneficiaire->quot_foy = $request->quot_foy;
        $beneficiaire->droits = $request->droits;
        // AIDANT
        $beneficiaire->aidant_type_aide = $request->aidant_type_aide;
        $beneficiaire->aidant_sante = $request->aidant_sante;
        $beneficiaire->aidant_ressenti = $request->aidant_ressenti;
        $beneficiaire->aidant_relais = $request->aidant_relais;
        $beneficiaire->aidant_relais_desc = $request->aidant_relais_desc;
        //
        $beneficiaire->obs = $request->obs;
        $beneficiaire->statut = $request->statut;
        $beneficiaire->verrou = ($request->verrou=='')?0:1;
        $beneficiaire->save();
        //LOG de la transaction
        $beneficiaire->log_transaction($request->url(),'U');

        return $beneficiaire;
    }

    public function autocomplete_conjoint(BeneficiairesAutoRequest $request)
    {
        //return json_encode(array('aa','bb'));
        $param = $request->term;
        $associate = array();
        $search    = DB::select(
            "select id ,CONCAT(TRIM(nom) ,
                    '  ',
                    TRIM(prenom),
                    '  (',
                    DATE_FORMAT(datenaiss, '%d/%m/%Y')
                    ,')'
                ) as value
                from beneficiaires
                where nom like ('{$param}%') or id='{$param}%'
            "
        );
        foreach ($search as $result) {
            $associate[] = $result;
        }
        $associate[]=["id"=>'',"value"=>'Aucun'];
        return json_encode($associate);
    }



}
