<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\District;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use App\Http\Requests\DistrictRequest;
use View;
 
class DistrictsController extends Controller {

    private $menu='parametres';
    private $submenu='districts';

    public function index()
    {
       if(!($user=Auth::user())) return Redirect::route( 'login' );
       if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("DIS_VISU")) return redirect('home');
        $districts = District::all();

        return View::make('param.districts.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'districts'=>$districts
        ]);
    }
 

    public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("DIS_AJO")) return redirect('home');

        $districts=District::orderby('nom')->get()->pluck("nom", "id")->toArray();
        $mode="create";
        return View::make('param.districts.create', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode"=>$mode,
            "districts" => $districts
        ]);
    }


    public function store(DistrictRequest $request)
    {
        $district = $this->setData($request);
        $msg="Le District ".$district->nom." a été créé";
        Session::flash('message', $msg);
        return Redirect::to('districts');
    }
 

    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if($mode=="edit") if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("DIS_MAJ")) return redirect('home');
        else if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("DIS_VISU")) return redirect('home');

        $district = District::find($id);

        $districts=District::orderby('nom')->get()->pluck("nom", "id")->toArray();
        return View::make('param.districts.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode"=>$mode,
            "district" => $district,"districts" => $districts
        ]);
    }
 
    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        return $this->edit($id,"show");
    }

    public function update($id,DistrictRequest $request)
    {
        $district = $this->setData($request,$id);
        $msg="Le District ".$district->nom." a été mis à jour";
        Session::flash('message', $msg);
        return Redirect::to('districts');
    }
 

    public function destroy($id)
    {
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("DIS_SUP")) return redirect('home');

        District::destroy($id);
        return Redirect::to('districts');
    }
 
    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $district =  new District;
        else $district = District::find($id);
        
        $district->nom  = ($request->nom);
        $district->royaume  = ($request->royaume);
        $district->code_postal   = $request->code_postal; 
        $district->save();

        return $district;
    }
}