<?php

namespace App\Http\Controllers;

use View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Connection;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class HomeController extends Controller
{

    private $menu_home='';
    private $menu='';
    private $submenu='';
    public $role_name="";

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    public function index()
    {
        $user = Auth::user();
        if(!$user) return;

        $this->role_name=$user->getRoleNames()->first();


        return $this->dash_Administrateur();
    }

    public function index_type($type)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $dashboard_title="";$menu_home="";
        if(($type=strtoupper($type))=="PAN") {
            $menu_home="prime_naissance";
            $dashboard_title = MyApp::TYPES_AIDES[$type];
        }
        $t_indicateurs=MyApp::getIndicateurs($type);

        return view::make('home',[
            "user"=>$user,
            "dashboard_title"=>$dashboard_title,
            "menu_home" => $menu_home,
            "t_indicateurs" => $t_indicateurs
        ]);
    }

    public function dash_Administrateur()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $users=User::where('name','<>','')->get();
        $this->role_name=$user->getRoleNames()->first();

        $dashboard_title = "Gestion des Aides Sociales";
        $menu="";$submenu="";
        $t_indicateurs=MyApp::getIndicateurs();

        return view::make('home',[
            "user"=>$user,'menu_home' => $this->menu_home,'menu' => $this->menu,'submenu' => $this->submenu,
            "dashboard_title"=>$dashboard_title,
            "submenu" => $submenu,"menu" => $menu,
            "t_indicateurs" => $t_indicateurs

        ]);
    }


}
