<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\Log;
use App\Models\User;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;


class LogsController extends Controller {
    private $menu='acces';
    private $submenu='users';

    /**
     * Liste des controles
     */
    public function index_user($user_id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $user_search=User::where('id','=',$user_id)->first();

        $user_logs=Log::where('table','=','users')
                        ->where('values','like',"id=>".$user_id.";%")
                        ->orderby('date','DESC')
                        ->get();

        $role_logs=Log::where('table','=','role_user')
                        ->where('values','like',"user_id=>".$user_id.";%")
                        ->orderby('date','DESC')
                        ->get();
        $t_res=array();
        foreach($user_logs as $user_log)  {
            $t_res[$user_log->DateUS]=["date"=>$user_log->DateUS,"login"=>$user_log->login
                ,"ip"=>$user_log->ip,"value"=>$user_log->ValueUser,"role"=>""];

            $role_logs=Log::where('table','=','role_user')
                            ->where('values','like',"user_id=>".$user_id.";%")
                            ->where('date','like',$user_log->DateUS."%")
                            ->orderby('date','DESC')
                            ->get();
            $value="";
            foreach($role_logs as $role_log) $value.=substr($role_log->values,strpos($role_log->values, ";")+1);
            if($value) $t_res[$user_log->DateUS]["role"]=$value;
        }


        krsort($t_res);
        return View::make('logs.index_users', [
            'user' => $user_search,'menu' => $this->menu,'submenu' => $this->submenu,
            't_res' => $t_res,

        ]);
    }

}
