<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use View;
use DB;

class StatsController extends Controller {

    private $menu='statistiques';
    private $submenu='stats';

    public function getIndexTDB()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );


        return View::make('stats.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
        ]);
    }

    public function getIndex($type,$annee="",$ile="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($annee!="") Session::put("annee",$annee);
        else $annee=Session::get('annee');
        if($annee=="") $annee=date('Y');


        if($ile!="") Session::put("ile",$ile);
        else $ile=Session::get('ile');

        $data_saisie=[];$data_saisieW=[];$data_saisieF=[];$data_table=[];
        $t_data=$this->getImmatMensuellesData($annee,$type);
        foreach($t_data as $key=>$t) {
            $mois=$t[0];
            $nb=$t[1];
            $nbW=$t[2];
            $nbF=$t[3];
            $labels[]=$mois;
            $data_saisie[]=$nb;
            $data_saisieW[]=$nbW;
            $data_saisieF[]=$nbF;
            $data_table[$mois]=$nb;
            if($ile=="W") $data_table[$mois]=$nbW;
            if($ile=="F") $data_table[$mois]=$nbF;
        }

        $iles=MyApp::ILES+['ALL'=>'Cumulé','AL2'=>'Tout'];
        $annees=MyApp::getAnneesPop()+['9999'=>'Tout'];
        if($type=="saisie") {
            $this->submenu='stat_saisie';
            $titre="Saisie des immatriculations";

        } else {
            $this->submenu='stat_immat';
            $titre="Nouvelles immatriculations";
        }

        return View::make('stats.index_saisie', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'iles' => $iles,'annees' => $annees,'annee' => $annee,'ile' => $ile,
            "data_table" => $data_table,
            "data_saisie" => $data_saisie,"data_saisieW" => $data_saisieW,"data_saisieF" => $data_saisieF,"labels" => $labels,"titre" => $titre
        ]);
    }

    public function getIndexSaisie($annee="",$ile="")
    {
        return $this->getIndex("saisie",$annee,$ile);
    }

    public function getIndexImmat($annee="",$ile="")
    {
        return $this->getIndex("immat",$annee,$ile);
    }



    public function getImmatMensuellesData($annee,$type)
    {
        $stats = $this->getImmatMensuelles($annee,$type);
        $res=array();
        foreach($stats as $stat) {
            $res[]=[
                $stat["mois"],
                $stat["nb_immat"],
                $stat["nb_w"],
                $stat["nb_f"],
            ];
        }
        return $res;
    } 

    public function getImmatMensuelles($annee,$type)
    {
        $champ=($type!="saisie")?"date_emission":"created_at";

        $stats = DB::table('vehicules')
            ->select(DB::raw('LEFT('.$champ.',7) as mois,count(0) as nb_immat'))
            ->where(DB::raw('YEAR('.$champ.')'),'>=',$annee)
            ->groupBy('mois')
            ->orderby('mois')
            ->get([
                DB::raw('mois'),
                DB::raw('nb_immat'),
            ]);

        $t_id_communesW=MyApp::getIdVillagePop("W");
        $t_id_communesF=MyApp::getIdVillagePop("F");

        $res=array();
        foreach($stats as $stat) {
            $mois=$stat->mois;
            $nb_W=DB::table('vehicules')->where($champ,"like",$mois."%")->whereIn('commune_id',$t_id_communesW)->count();
            $nb_F=DB::table('vehicules')->where($champ,"like",$mois."%")->whereIn('commune_id',$t_id_communesF)->count();
        
            $res[]=[
                "mois"=>$stat->mois,
                "nb_immat"=>$stat->nb_immat,
                "nb_w"=>$nb_W,
                "nb_f"=>$nb_F
            ];
        }
        return $res;
    }


    /* ************ IMMATRICULATIONS MENSUELLES ******************** */
    /*
    public function getApiImmatMensuelles($annee)
    {
        $stats = DB::table('vehicules')
            ->select(DB::raw('LEFT(date_emission,7) as mois,count(0) as nb_immat'))
            ->where(DB::raw('YEAR(date_emission)'),'>=',$annee)
            ->groupBy('mois')
            ->orderby('mois')
            ->get([
                DB::raw('mois'),
                DB::raw('nb_immat'),
            ]);

        $t_id_communesW=MyApp::getIdVillagePop("W");
        $t_id_communesF=MyApp::getIdVillagePop("F");

        $res=array();
        foreach($stats as $stat) {
            $mois=$stat->mois;
            $nb_W=DB::table('vehicules')->where("date_emission","like",$mois."%")->whereIn('commune_id',$t_id_communesW)->count();
            $nb_F=DB::table('vehicules')->where("date_emission","like",$mois."%")->whereIn('commune_id',$t_id_communesF)->count();
        
            $res[]=[
                "mois"=>$stat->mois,
                "nb_immat"=>$stat->nb_immat,
                "nb_w"=>$nb_W,
                "nb_f"=>$nb_F
            ];
        }
        return $res;
    }


    public function getApiImmatMensuellesData()
    {
        $stats = $this->getApiImmatMensuelles();
        $res=array();
        foreach($stats as $stat) {
            $res[]=[
                $stat["mois"],
                $stat["nb_immat"],
            ];
        }
        return $res;
    } 
    */



     /* ************ SAISIES MENSUELLES ******************** */
    public function getApiSaisiesMensuelles()
    {
        $stats = DB::table('vehicules')
            ->select(DB::raw('LEFT(created_at,7) as mois,count(0) as nb_saisies'))
            ->groupBy('mois')
            ->orderby('mois')
            ->get([
                DB::raw('mois'),
                DB::raw('nb_saisies'),
            ]);

        $res=array();
        foreach($stats as $stat) {
            $res[]=[
            "mois"=>$stat->mois,
            "nb_saisies"=>$stat->nb_saisies
            ];
        }
        return $res;
    }


    public function getApiSaisiesMensuellesData()
    {
        $stats = $this->getApiSaisiesMensuelles();
        $res=array();
        foreach($stats as $stat) {
            $res[]=[
                $stat["mois"],
                $stat["nb_saisies"],
            ];
        }
        return $res;
    }

}
