<?php namespace App\Http\Requests;
 
use Illuminate\Foundation\Http\FormRequest;
 
class VehiculeRequest extends FormRequest {
    public function rules() {
        return [
            'numero' => '',
            'date_emission' => 'required',
            'date_prem' => 'required',
            'date_prem_wf' => '',
            'prop1_nom' => 'required|max:100',
            'prop1_ridet' => 'max:9',
            'prop1_categ' => 'max:2',
            'prop2_nom' => 'max:100',
            'prop2_ridet' => 'max:9',
            'prop2_categ' => 'max:2',
            'locataire1_nom' => 'max:100',
            'locataire2_nom' => 'max:100',
            'locataire3_nom' => 'max:100',
            'domicile' => 'required|max:255',
            'commune_id' => 'required',
            'bp' => 'max:5',
            'commune_bp_id' => '',
            'marque' => 'required|max:100',
            'genre' => 'required|min:2|max:10',
            'type_serie' => 'required|max:17',
            'type' => 'required|max:50',
            'carosserie' => 'max:20',
            'energie' => 'required|max:3',
            'puissance' => 'required|max:3',
            'appelation' => 'max:100',
            'places' => 'required|max:2',
            'cylindree' => 'max:5',
            'utilisation' => 'max:10',
            'poids_tc' => 'required|max:5',
            'poids_vide' => 'required|max:5',
            'poids_total' => 'max:5',
            'charge' => 'max:3',
            'bruit' => 'max:3',
            'regime_mot' => 'max:5',
            'immat_prec_date' => '',
            'immat_prec_numero' => 'max:20',
            'date_visite' => '',
            'observations' => '',
            'declaration_num' => '',
            'declaration_date' => '',
            'declaration_liq' => 'max:10',
        ];
    }
 

     public function attributes() {
        return [
            'numero' => 'Numero',
            'domicile' => 'Domicile',
            'marque' => 'Marque',
            'genre' => 'Genre',
            'type_serie' => 'Type dans la série',
            'type' => 'Type',
            'energie' => 'Energie',
            'puissance' => 'Puissance',
            'places' => 'Paces',
            'commune_bp_id' => 'Commune de la boite postale',
            'commune_id' => 'Commune',
            'date_emission' => "Date d'emission",
            'date_prem' => 'Date de première immatriculation',
            'prop1_nom' => 'Nom du propriétaire',
            'poids_tc' => 'Poids TC',
            'poids_vide' => 'Poids à Vide',
            'date_prem_wf' => '1ère Immat.',
            'prop1_ridet' => 'RIDET',
            'prop1_categ' => 'Catég.Prof.',
            'prop2_nom' => 'NOM Prénoms ou Raison sociale',
            'prop2_ridet' => 'RIDET',
            'prop2_categ' => 'Catég.Prof.',
            'locataire1_nom' => 'Nom du locataire 1',
            'locataire2_nom' => 'Nom du locataire 2',
            'locataire3_nom' => 'Nom du locataire 3',
            'bp' => 'Boite Postale',
            'carosserie' => 'Carosserie',
            'appelation' => 'Appelation commerciale',
            'cylindree' => 'Cylindrée',
            'utilisation' => 'Utilisation',
            'poids_total' => 'PTR(kg)',
            'charge' => 'ChgUt(kg)',
            'bruit' => 'Bruit(dB)',
            'regime_mot' => 'Rég.Moteur (tr/mn)',
            'immat_prec_date' => 'Date Immat. précédente',
            'immat_prec_numero' => 'N° du certificat précédent',
            'date_visite' => '',
            'observations' => 'Observations',
            'declaration_num' => 'Numéro de déclaration',
            'declaration_date' => 'Date de la déclaration',
            'declaration_liq' => 'Numéro de liquidation',

        ];
    }


    public function authorize() {
        return true;
    }
}