<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;
use Illuminate\Support\Facades\Auth;

class Beneficiaire extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'beneficiaires';



  public function enfants()
    {
        return $this->hasMany('Enfant','parents1','benjum');
    }

    public function enfants_conjoint()
    {
        return $this->hasMany('Enfant','parents2','benjum');
    }


    /* Dates */
    public function getDates()
    {
            return array('datenaiss','ret_dateed','date_pi');
    }


    public function getDateNaissAttribute($value)
    {
        return ($this->attributes['datenaiss']!=null)?date('d/m/Y', strtotime($this->attributes['datenaiss'])):null;
    }

     public function getDateDecesAttribute($value)
    {
        return ($this->attributes['date_deces']!=null)?date('d/m/Y', strtotime($this->attributes['date_deces'])):null;
    }

     public function getRetDateedAttribute($value)
    {
        return ($this->attributes['ret_dateed']!=null)?date('d/m/Y', strtotime($this->attributes['ret_dateed'])):null;
    }
     public function getDatePiAttribute($value)
    {
        return (($this->attributes['date_pi']!=null))?date('d/m/Y', strtotime($this->attributes['date_pi'])):null;
    }



    /***************/
    /* NOM ADRESSE */
    /***************/

    /* NOM+PRENOM  */
    public function getNomCompletAttribute()
    {
            return $this->nom." ".$this->prenom;
    }


    /* NOM seul pour éditions */
    public function getNomReduit($taille_max=20)
    {
        $nom=trim($this->nom);
        if(strlen($nom)>$taillemax) $nom=substr($nom,0,$taillemax);
        return trim($nom);
    }

    /* NOM+PRENOM pour éditions */
    public function getNomCompletReduit($taille_max=20)
    {
        $t_prenom=explode(' ',$this->prenom);
        $prenom=trim($t_prenom[0]);
        if(strlen($prenom)>$taillemax) $prenom=substr($prenom,0,$taillemax);
        return trim($this->nom)." ".$prenom;
    }

    /* NOM+PRENOM (1er lettre si > taille) pour éditions */
    public function getNomPrenomReduit($taillemax=30)
    {
        $nom=trim($this->nom);
        if(strlen($nom)>$taillemax) $nom=substr($nom,0,$taillemax);
        $t_prenom=explode(' ',trim($this->prenom));
        $prenom=trim($t_prenom[0]);
        if(strlen($nom." ".$prenom)>$taillemax) $prenom=substr($prenom,0,1).".";

        return trim($nom." ".$prenom);
    }

 
    /***************/
    /* NOM ADRESSE */
    /***************/









  /**
   * Fiche Supprimable ?
   */
  public function canIsSupprimableAttribute()
  {
    if(!($user=Auth::user())) return Redirect::route( 'login' );
    if (!$user->can("BEN_SUP") && !$user->HasRole("ADMINISTRATEUR")) return false;

    return false;
  }



  //LOG
  public function log_transaction($url,$operation,$values="") {
    $log=new Logs;
    if($values=="") {
      $t_values=$this->getAttributes();
      foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value;
    }

    $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
  }
}
