<?php namespace App\Models;

use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;

class Village extends Model
{
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'villages';
	public  $timestamps = false;



     public function getFullNameAttribute($value)
    {
        $district=District::find($this->district_id);
        return $this->nom." (".$district->code_postal." ".$district->royaume.")";
    }

     public function getDistrictAttribute($value)
    {
    	$district=District::find($this->district_id);
        return $district->nom;
    }

     public function getRoyaumeAttribute($value)
    {
    	$district=District::find($this->district_id);
        return $district->royaume;
    }

    public function getNbVehiculesAttribute()
    {
        $nb_vehicules=Vehicule::where('commune_id','=',$this->id)->count();
        return $nb_vehicules;
    }


    /**
    * Fiche Supprimable ?
    */
    public function getIsSupprimableAttribute()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if (!$user->can("VIL_SUP") && !$user->HasRole("ADMINISTRATEUR")) return false;
        $nb=$this->NbVehicules;
        if($nb>0) return false;

        return true;
    }


}