@extends('layouts.dash')
@section('title') Utilisateur @stop
@section('title_card') Nouvel Utilisateur @stop


@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card card-success">
        <div class="card-header">
            <h2>Nouvel utilisateur</h2>
        </div>
        <div class='card-body'>
            {{ html()->form('POST', url('users'))->open() }}
                @include("acces.users.content")
            {{ html()->closeModelForm() }}
        </div>
    </div>
@stop

@section('scripts')
    <script>
        $(function() {
            $('.select2').select2();
        })
    </script>
@stop
