@extends('layouts.dash')
@section('title') Utilisateur @stop
@section('title_card') Mise à jour d'un Utilisateur @stop


@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card card-success">
        <div class="card-header">
            <h2>Utilisateur <span style='color:darkblue'>{!! $user_sel->nomcomplet !!}</span></h2>
        </div>
        <div class='card-body'>
            {{ html()->modelForm($user_sel)->open() }}
                @include("acces.users.content")
            {{ html()->closeModelForm() }}
        </div>
    </div>
    <div class='card-footer'>
        @if($user->hasrole("ADMINISTRATEUR"))
            <a href="{!! url('log_user/'.$user_sel->id) !!} " class="box_imput fancybox.iframe">
                {!! html()->button('journal')->value('Journal des modififcations')->attributes(['class' => 'btn btn-info']) !!}
            </a>
        @endif
    </div>
@endsection

@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop

@section('scripts')
    <script>
        $(function() {
            $('.select2').select2();
        })
    </script>
@stop

@section('scripts_end')
    <!-- FancyBox -->
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script>
        $(".box_imput").fancybox({
            width:'90%',
            autoDimensions:false,
            fitToView   : false,
            autoSize    : false,
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
            afterLoad: function () {
                eTarget=$(this.element).attr("id");
            },
            afterClose: function () {
                if (eTarget!="btn_visu_imputation") {
                    $("#refresh").val(true);
                    $("#form").submit();
                }
                return;
            }
        });
    </script>


@stop
