@extends('layouts.dash')
@section('title') Statistiques @stop



@section('content')
 <div class="row">
    <!-- GRAPH-->
    <div class="col-md-8">
        <div class="card card-{{ ($submenu=='stat_immat')?'warning':'primary' }}">
            <div class="card-header">
                <h3 class="card-title">{{ $titre }} - Graphique</h3>
                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                  </button>
                  <button type="button" class="btn btn-tool" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                  </button>
                </div>
            </div>
            <div class="card-body">
                <div class="form-group row">
                    <div class='col-md-2'>
                        {!! html()->select('annee')->options($annees)
                            ->value(isset($annee)?$annee:"")
                            ->placeholder('Depuis...')
                            ->attributes(['class' => 'form-control','id' => 'select_annee'])  !!}
                    </div>
                    <div class='col-md-3'>
                        {!! html()->select('select_ile')->options($iles)
                            ->value(isset($ile)?$ile:"")
                            ->placeholder('Choisr une origine')
                            ->attributes(['class' => 'form-control','id' => 'select_ile'])  !!}
                    </div>
                </div>

                <div class="chart"><div class="chartjs-size-monitor"><div class="chartjs-size-monitor-expand"><div class=""></div></div><div class="chartjs-size-monitor-shrink"><div class=""></div></div></div>
                    <canvas id="areaChart" style="min-height: 250px; height: 450px; max-height: 450px; max-width: 100%; display: block; width: 621px;" width="558" height="224" class="chartjs-render-monitor"></canvas>
                </div>
            </div>
        </div>
    </div> 

    <!-- GRAPH-->
    <div class="col-md-4">
        <div class="card card-{{ ($submenu=='stat_immat')?'warning':'primary' }}">
            <div class="card-header">
                <h3 class="card-title">{{ $titre }} - Données</h3>
            </div>
            <div class="card-body">
                <table id="_table" class="table table-condensed  table-striped table-bordered">
                    <thead>
                        <tr>
                            <th style='vertical-align:middle'>Année/Mois</th>
                            <th style='text-align:center'>{{ ($submenu=="stat_immat")?"NbImmat.":"NbSaisies" }}</th>
                        </tr>
                    </thead>    
                    <tbody>
                        @foreach($data_table as $mois=>$data)
                            <tr>
                                <td align="center">{!! $mois !!}</td>
                                <td align="right">{!! $data !!}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
    
@stop

@section('scripts')

    <script src="{{ url('AdminLTE-master/plugins/chart.js/Chart.min.js') }}"></script>

    <script>
      $(function () {
        $("#_table").DataTable({
          "paging": true,
          "lengthChange": false,
          "searching": false,
          "ordering": true,
          "info": false,
          "responsive": true,
          "autoWidth": true,
          "fixedHeader": true,
           oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                "oPaginate": {"sPrevious": "<","sNext": ">"
                    ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                    "sSearch":"Chercher",
            },
            dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'><'col-sm-4'p>>",
        })
        .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');
      });
    </script>

    <script>
        $(function () {
            $('#select_annee').change(function() {select_filtre();});
            $('#select_ile').change(function() {select_filtre();});

            function select_filtre() {
                var annee=$('#select_annee').val();
                if(annee=="") annee=0;
                var ile=$('#select_ile').val();
                if(ile=="") ile=0;
                url="{!! url('stat_saisie/') !!}"+"/"+annee+"/"+ile  ;
                location.href=url;
            }
        });

        $(function () {
            //--------------
            //- AREA CHART -
            //--------------
            // Get context with jQuery - using jQuery's .get() method.
            var areaChartCanvas = $('#areaChart').get(0).getContext('2d')

            var areaChartData = {
              labels  : {!! json_encode($labels) !!},
              datasets: [
                @if(($ile=="ALL")||($ile=="AL2"))
                {
                  label               : 'Wallis&Futuna',
                  backgroundColor     : 'rgba(60,141,188,0.9)',
                  borderColor         : 'rgba(60,141,188,0.8)',
                  pointRadius          : false,
                  pointColor          : '#c1c7d1',
                  pointStrokeColor    : 'rgba(60,141,188,0.8)',
                  pointHighlightFill  : '#fff',
                  pointHighlightStroke: 'rgba(60,141,188,1)',
                  data                : {!! json_encode($data_saisie) !!}
                },
                @endif

                @if(($ile=="AL2")||($ile=="W"))
                {
                  label               : 'Wallis',
                  backgroundColor     : 'rgba(232, 241, 200, 1)',
                  borderColor         : 'rgba(232, 241, 200, 1)',
                  pointRadius         : false,
                  pointColor          : 'rgba(232, 241, 200, 1)',
                  pointStrokeColor    : '#c1c7d1',
                  pointHighlightFill  : '#fff',
                  pointHighlightStroke: 'rgba(220,220,220,1)',
                  data                : {!! json_encode($data_saisieW) !!}
                },
                @endif
                
                @if(($ile=="AL2")||($ile=="F"))
                {
                  label               : 'Futuna',
                  backgroundColor     : 'rgba(249, 216, 162, 1)',
                  borderColor         : 'rgba(249, 216, 162, 1)',
                  pointRadius         : false,
                  pointColor          : 'rgba(249, 216, 162, 1)',
                  pointStrokeColor    : '#c1c7d1',
                  pointHighlightFill  : '#fff',
                  pointHighlightStroke: 'rgba(220,220,220,1)',
                  data                : {!! json_encode($data_saisieF) !!}
                },
                @endif
              ]
            }

            var areaChartOptions = {
              maintainAspectRatio : false,
              responsive : true,
              legend: {display: true},
              scales: {
                xAxes: [{gridLines : {display : false,}}],
                yAxes: [{gridLines : {display : false,}}]
              }
            }
            // This will get the first returned node in the jQuery collection.
            new Chart(areaChartCanvas, {
              type: 'line',
              data: areaChartData,
              options: areaChartOptions
            })
        })
    </script>


@endsection
