@extends('layouts.dash')
@section('title') Banque @stop


@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card card-success">
        <div class="card-header">
            <h2 class="card-title">Nouveau bénéficiaire</h2>
        </div>
        {{ html()->form('POST', url('banques'))->open() }}
            <input type="hidden" name="type" value="{!! $type !!}">
            @include("tiers.beneficiaires.content")
        {{ html()->form()->close() }}
    </div>
</div>
@stop


@section('scripts')
    <script>
        $(function() {

            $('#datepicker_date_naissance').datepicker({
            format: "dd/mm/yyyy",language: "fr",autoclose: true
            });
            
            $('#datepicker_date_deces').datepicker({
            format: "dd/mm/yyyy",language: "fr",autoclose: true
            });


            var data_roles={!! $data_roles_json !!};
            
            $('#sel_roles').select2({
                width:'100%',
                data: data_roles,
                placeholder:"Rechercher"   
            });

            $(document).on("select2:open", () => {
              document.querySelector(".select2-container--open .select2-search__field").focus()
            })
        });
    </script>
@endsection