@extends('layouts.dash')
@section('title') Bénéficiaires @stop

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif


    <div class="card">
        <div class="card-header">
            <h3 class="card-title">{{ $title }}&nbsp;<small>Liste des bénéficiaires</small></h3>

        </div>
        <div class="card-body">
            @if($user->can("BEN_AJO") || $user->HasRole("ADMINISTRATEUR"))
                <div class="row">
                    <div class="col-4">
                        {!! html()->label( '&nbsp;','') !!}<br/>
                        {!! html()->a(url('beneficiaire_add/'.strtolower($type)),"Ajouter un bénéficiaire")->attributes(['class' => 'btn btn-success'])  !!}
                    </div>
                </div>  
            @endif
            <table id="_table" style="background-color:white;width:100%" class="table table-striped table-bordered table-hover">
                <thead>
                    <tr>
                        <th width='1px'>Id</th>
                        <th >Nom</th>
                        <th width='1px'>Date de naissance</th>
                        <th >Conjoint</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'>Création</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($beneficiaires as $beneficiaire)
                        <tr>
                            <td>{!! str_pad($beneficiaire->id, 5, "0", STR_PAD_LEFT) !!}</td>
                            <td>
                                <a href="{!! url('beneficiaires_filtre/'.$beneficiaire->id.'/'.$benef_type) !!}">
                                    {!! $beneficiaire->nom_complet !!}
                                </a>
                            </td>
                            <td>{!! $beneficiaire->datenaiss !!}</td>
                            <td>{!! $beneficiaire->NomConjoint !!}</td>
                            <td align="center">{!! $beneficiaire->statut !!}</td>
                            <td align="center" title="{!! $beneficiaire->created_at !!}">{!! substr($beneficiaire->created_at,0,10) !!}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable_btn")
@endsection
