

    <div class="callout callout-danger">
        <div class="form-group row">
            <div class="col-md-6">
                {!! html()->label( 'Conjoint','nom_conjoint') !!}
                {!! html()->hidden('conjoint', null)->attributes(['id' => 'conjoint']) !!}

                <div class="input-group ">
                    <div class="input-group-prepend">
                        <span class="input-group-text"  name="conjoint_addon" id='conjoint_addon'>{!! isset($beneficiaire)?str_pad($beneficiaire->conjoint, 6, "0", STR_PAD_LEFT):'' !!}</span>
                    </div>
                    {!! html()->text('nom_conjoint', isset($beneficiaire)?$beneficiaire->nom_conjoint:'')
                        ->placeholder("Conjoint")
                        ->attributes([($mode=="show"?'disabled':''), 'id'=>'nom_conjoint','class' => 'form-control'])
                    !!}
                </div>
            </div>
        </div>

        <div class="form-group row">
            <div class='col-md-2'>
                {!! html()->label( "Nbr d'enfants",'nb_enf') !!}
                {!! html()->text('nb_enf', null)->placeholder("Nombre d'enfants")->attributes([($mode=="show"?'disabled':''), 'class' => 'text-right form-control']) !!}
            </div>

            <div class='col-md-2'>
                {!! html()->label( "Nbr d'enfants total",'nb_enf_tot') !!}
                {!! html()->text('nb_enf_tot', null)->placeholder("Nombre d'enfants total")->attributes([($mode=="show"?'disabled':''), 'class' => 'text-right form-control']) !!}
            </div>
        </div>

        @if(isset($beneficiaire))
            <div class="form-group row">
                <div class="col-xs-12" >
                    <h4>Enfants</h4>
                    <table id="_table_famille" class="table table-condensed table-striped table-bordered" width="100%" >
                        <thead>
                            <tr>
                                <th width='1%'>Id</th>
                                <th width='20%'>Nom</th>
                                <th width='10%'>Prenom</th>
                                <th width='5%'>Date&nbsp;de&nbsp;naissance</th>
                                <th width='5%'>Age</th>
                                <th width='1%'>Sexe</th>
                                <th width='20%'>Certificat</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($enfants as $enfant)
                            <tr>
                                <td>
                                    <a href="{!! url('enfants_show_avec_benef/'.$enfant->id.'/'.$beneficiaire->id) !!}"
                                        style="text-decoration:none"  class="btn btn-sm bg-info box_enfant fancybox.iframe" >
                                        {!! str_pad($enfant->id, 6, "0", STR_PAD_LEFT) !!}
                                    </a>
                                </td>
                                <td>{!! $enfant->nom !!}</td>
                                <td nowrap>{!! $enfant->prenom !!}</td>
                                <td align="center">{!! $enfant->datenais !!}</td>
                                <td align="center">{!! $enfant->Age !!}&nbsp;ans</td>
                                <td align="center">{!! $enfant->sexe !!}</td>
                                <td align="center">{!! $enfant->certif !!}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            @if(($mode=="show"))
                @if($user->can("ENF_AJO") || $user->HasRole("ADMINISTRATEUR"))
                    <div class="form-group row">
                        <a href="{!! url('enfants_create_avec_benef/'.$beneficiaire->id) !!}" class="box_enfant fancybox.iframe">
                            <input type="button" class="btn btn-success" value="Ajouter un enfant" />
                        </a>
                    </div>
                @endif
            @endif
        @endif
    </div>


