<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BotManController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/logout', 'App\Http\Controllers\Auth\LoginController@logout');

Auth::routes();

Route::get('change_profil',array('as' => 'change_profile' , 'uses' => 'App\Http\Controllers\Auth\ChangeProfilController@newprofil'));
Route::put('change_profil',array('as' => 'change_profile' , 'uses' => 'App\Http\Controllers\Auth\ChangeProfilController@changeprofil'));

Route::get('change_pwd', array('as' => 'change_pwd', 'uses'=>'App\Http\Controllers\UsersController@resetpassword')); // Liste formulaires
Route::post('pwd_reset', array('as' => 'pwd_reset', 'uses'=>'App\Http\Controllers\UsersController@postReset')); // Liste formulaires


Route::get('/', function () {
    return view('welcome');
});

Route::get('/home', 'App\Http\Controllers\HomeController@index')->name('home');
Route::get('/home/{type}', 'App\Http\Controllers\HomeController@index_type')->name('home');

/* ***** ACCES / USERS / ROLES / PERMISSIONS ***** */
Route::resource('/users', 'App\Http\Controllers\UsersController');
Route::delete('/users/delete/{id}','App\Http\Controllers\UsersController@destroy');

Route::resource('/roles', 'App\Http\Controllers\RolesController');
Route::get('/roles_det', 'App\Http\Controllers\RolesController@index_det');
Route::get('/roles_tableau', 'App\Http\Controllers\RolesController@index_tableau');
Route::get('/role_tableau_filtre/{id}', 'App\Http\Controllers\RolesController@index_tableau');

Route::resource('/permissions', 'App\Http\Controllers\PermissionsController');


/* ********* PRIME NAISSANCE ********** */

Route::get('beneficiaire_add/{type?}', 'App\Http\Controllers\BeneficiairesController@create');
Route::resource('beneficiaires/{type?}', 'App\Http\Controllers\BeneficiairesController');

/* ********* LOGS ********** */
Route::get('/log_user/{usr_id}', 'App\Http\Controllers\LogsController@index_user');

/* ********* LOGS ********** */
Route::get('parametres', 'App\Http\Controllers\ParametresController@index');
Route::get('parametres/{categorie}', 'App\Http\Controllers\ParametresController@index');
Route::PUT('categorie', 'App\Http\Controllers\ParametresController@update');


/* ********* Villages Districts Données de base ********** */
Route::resource('villages', 'App\Http\Controllers\VillagesController');
Route::resource('districts', 'App\Http\Controllers\DistrictsController');




/* ********* STATS ********** */
