<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Allocataire;
use App\Models\Famille;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use View;
 

/* ****************************** */
/* AAE
/* ****************************** */
class AidesController extends Controller {
    private $menu_home="aides";
    private $menu='aae';
    private $submenu='allocataires';
    

    //Liste générique
    public function index($type_aide,$ile="",$filtre="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_VISU")) return redirect('home');

        $this->menu=strtolower($type_aide);
        $this->submenu="aides_".strtolower($type_aide);
        $title=MyApp::TYPES_AIDES[$type_aide];
        $all_allocataires = Allocataire::where('types_aides','like','%'.$type_aide.'%')->orderBy('nom')->orderBy('prenom')->get();
        $allocataires=collect();
        
        foreach($all_allocataires as $allocataire) {
            $isOK=true;
            $alloc_ile=$allocataire->Ile;
            if($ile) {
                if($ile!="A") {
                    if($alloc_ile!=$ile) $isOK=false;
                } else {
                    if(($alloc_ile=="W")||($alloc_ile=="F"))  $isOK=false;
                }   
            }
            if($isOK) $allocataires->push($allocataire);
        }

        return View::make('aides.index_'.strtolower($type_aide), [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'title' => $title,'type_aide' => $type_aide,"ile" => $ile,
            'allocataires' => $allocataires,
        ]);
    }
    
    //SET Statut Générique : commun AAE et FSOC
    public function index_set_statut($type_aide) {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("VER_".$type_aide."_PRP")) return redirect('home');


        $title=MyApp::TYPES_AIDES[$type_aide]." - Mise à jour des statuts Aide sur les fiches allocataire";
        $this->menu=strtolower($type_aide);
        $this->submenu='set_statut_'.strtolower($type_aide);;
        $familles_temp = Famille::orderBy('id')->get();
        $allocataires=[];$t_lignes=[];
        foreach($familles_temp as $famille) {
            $allocataire=$famille->getTitulaire();
            if($allocataire && !$allocataire->hasAide($type_aide)) {
                if($type_aide=="AAE") {
                    if($allocataire->NbEnfantsAAE>0) {
                        $allocataires[]=$allocataire;
                        $t_lignes[]=$allocataire->id;
                    }
                }
                if(($type_aide=="FSO")&&($allocataire->age>=18)&&($allocataire->age<=60)) {
                    if($allocataire->QF<MyApp::getParam("FSO_PLAFOND")) {
                        $allocataires[]=$allocataire;
                        $t_lignes[]=$allocataire->id;   
                    }
                }
            } 
        }
        return View::make('aides.index_set_statut', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'title' => $title,'type_aide' => $type_aide,
            'allocataires' => $allocataires,'t_lignes' => $t_lignes,
        ]);
    }

    

    
    //Change Statut Générique : commun AAE et FSOC
    public function change_statut(Request $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_MAJ")) return redirect('home');

        $remove_statut=0;
        $type_aide=$request->type_aide;
       
        $nb_maj=0;
        $liste_id=$request->list_check;
        $t_id=explode(";",$liste_id);
        $t_id_new_allocataire=[];

        foreach($t_id as $key=>$id) {
            $allocataire=Allocataire::find($id);
            if(($allocataire)&&(!$allocataire->hasAide($type_aide))) {
                $allocataire->types_aides.=(($allocataire->types_aides)?",":"").$type_aide;
                $allocataire->save();
                $nb_maj++;
            }
        }

        $msg=$nb_maj." ont été mises à jour";
        Session::flash('message', $msg);
        return redirect()->back();
    }

    /* ****************************** */
    /* AAE
    /* ****************************** */
    public function index_aae($ile="") {return $this->index("AAE",$ile);}
    public function set_statut_aae() {return $this->index_set_statut("AAE");}


    /* ****************************** */
    /* PAN
    /* ****************************** */
    public function index_PAN($ile=""){return $this->index("PAN",$ile);}

    /* ****************************** */
    /* CSR
    /* ****************************** */
    public function index_csr($ile="") {return $this->index("CSR",$ile);}

    /* ****************************** */
    /* FSO Filet Social
    /* ****************************** */
    public function index_fso($ile="") {return $this->index("FSO",$ile);}
    public function set_statut_fso() {return $this->index_set_statut("FSO");}
    //Set Refus pour FSO
    public function set_refus_fso($filtre="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("FSO_MAJ")) return redirect('home');
        $type_aide="FSO";
        $this->menu=strtolower($type_aide);
        $this->submenu='set_refus_'.strtolower($type_aide);;
        
        $t_lignes=[];
        $title=MyApp::TYPES_AIDES[$type_aide];
        $all_allocataires = Allocataire::where('types_aides','like','%'.$type_aide.'%')
            ->where("statut_dossier","=","ACT")->orderBy('nom')->orderBy('prenom')->get();
        
        $allocataires=[];$t_lignes=[];
        foreach($all_allocataires as $allocataire) {
            if(($type_aide=="FSO")&&($allocataire->age>=18)) {
                $isOK=true;
                if($filtre) {
                    $qf=$allocataire->QF;
                    $plafond=MyApp::getParam("FSO_PLAFOND");
                    if(($filtre=="QFSUP")&&($qf<$plafond)) $isOK=false;
                    else if(($filtre=="QFOK")&&($qf>=$plafond)) $isOK=false;
                }
                if($isOK) {
                    $allocataires[]=$allocataire;
                    $t_lignes[]=$allocataire->id;  
                } 
            }
        }
        $filtres=["QFSUP"=>"QF >= Plafond","QFOK"=>"QF < Plafond"];
        $raisons_fso=MyApp::getZBase("BEN_RAISONS_FSO")+['VIDE'=>'Supprimer la raison du refus'];
        return View::make('aides.index_set_refus', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'title' => $title,'type_aide' => $type_aide,
            'filtre' => $filtre,'filtres' => $filtres,'raisons_fso' => $raisons_fso,
            't_lignes' => $t_lignes,'allocataires' => $allocataires,
        ]);
    }

    //Change Statut Générique : commun AAE et FSOC
    public function change_refus_fso(Request $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_MAJ")) return redirect('home');

        $type_aide=$request->type_aide;
        $nb_maj=0;
        $liste_id=$request->list_check;
        $t_id=explode(";",$liste_id);
        $t_id_new_allocataire=[];
       
        foreach($t_id as $key=>$id) {
            $allocataire=Allocataire::find($id);
            if($allocataire) {
                $allocataire->raison_fso=($request->raison_fso=="VIDE")?null:$request->raison_fso;
                $allocataire->save();
                $nb_maj++;
            }
        }
        $msg=$nb_maj." ont été mises à jour";
        Session::flash('message', $msg);
        return redirect()->back();
    }

    //Elève l'aide pour les FSO 
    public function remove_aide_fso()
    {  
        $type_aide="FSO";
        $nb=0;
        $allocataires=Allocataire::where("types_aides","like","%".$type_aide."%")->get();
        foreach($allocataires as $allocataire) {
            $lst="";$nb++;
            $t_aides=explode(",",$allocataire->types_aides);
            foreach($t_aides as $aide) 
                if($aide!=$type_aide) $lst.=(($lst=="")?'':",").$aide;
            $allocataire->types_aides=$lst; 
            $allocataire->save();
        }
        $msg=$nb." allocataires ont été mis à jour";
        Session::flash('message', $msg);
        return redirect()->back();
    }

    /* ****************************** */
    /* AGD
    /* ****************************** */
    public function index_agd($ile="") {return $this->index("AGD",$ile);}

    /* ****************************** */
    /* APH
    /* ****************************** */
    public function index_aph($ile="") {return $this->index("APH",$ile);}
}