<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;

use App\Models\Allocataire;
use App\Models\AllocataireCompte;
use App\Models\Famille;
use App\Models\FamilleMembre;
use App\Models\FamilleEnfant;
use App\Models\Versement;
use App\Models\VersementRefus;
use App\Models\AllocataireRessource;
use App\Models\User;
use App\Models\MyApp;
use App\Models\Document;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use URL;
use App\Http\Requests\AllocataireRequest;
use App\Http\Requests\AllocataireAutoRequest;
use Illuminate\Http\Request;
use App\Models\Parametre;
use App\Http\Controllers\Logs;

class AllocatairesController extends Controller {

    private $menu_home="base";
    private $menu='dossiers';
    private $submenu='allocataires';

    public function index($ile="",$aide="",$activite="",$mode_aff="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_VISU")) return redirect('home');

        $title="";

        if($ile=="") $ile=MyApp::getSessionValue("select_ile","W");
        MyApp::putSessionValue("select_ile",$ile);

        if($aide=="") $aide=MyApp::getSessionValue("select_aide","");
        MyApp::putSessionValue("select_aide",$aide);

        if($activite=="") $activite=MyApp::getSessionValue("select_activite","");
        MyApp::putSessionValue("select_activite",$activite);

        if($activite) $all_allocataires = Allocataire::where("statut_dossier","=",$activite)->orderBy('nom')->orderBy('prenom')->get();
        else $all_allocataires = Allocataire::orderBy('nom')->orderBy('prenom')->get();
        $allocataires=collect();
        
        foreach($all_allocataires as $allocataire) {
            $isOK=true;
            $alloc_ile=$allocataire->Ile;
            if($ile) {
                if($ile!="A") {
                    if($alloc_ile!=$ile) $isOK=false;
                } else {
                    if(($alloc_ile=="W")||($alloc_ile=="F"))  $isOK=false;
                }   
            }
            if($isOK && $aide) if(!$allocataire->hasAide($aide)) $isOK=false;
            if($isOK) $allocataires->push($allocataire);
        }
        /*
        $t0 = time();
        $t_results=collect();
        foreach($allocataires as $allocataire) {
            $res=collect();
            $res->id_famille=$allocataire->id_famille;
            if($res->id_famille) {
                $famille=Famille::find($allocataire->id_famille);
                $res->IdPADFamille=$allocataire->IdPADFamille;
                $res->IsTitulaire=($famille->id_titulaire==$allocataire->id);
                $res->ConjointNomComplet=$allocataire->ConjointNomComplet;
                $res->NbEnfants=$allocataire->getNbEnfantsLESS() ;
                $res->EnfantsListe=($res->NbEnfants>0)?$allocataire->getEnfantsListe():0 ;
            } else {
                $res->IdPADFamille="";
                $res->IsTitulaire=1;
                $res->ConjointNomComplet="";
                $res->NbEnfants="" ;
                $res->EnfantsListe="";
            }
            $res->id=$allocataire->id;
            $res->IdPAD=$allocataire->IdPAD;
            $res->controle=$allocataire->controle;
            $res->statut_dossier=$allocataire->statut_dossier;
            $res->hasAAE=$allocataire->hasAide('AAE');
            $res->IdCPSWF=$allocataire->IdCPSWFPAD;
            $res->NomComplet=$allocataire->NomComplet2;
            $res->DateNaissance=$allocataire->date_naissance;
            $res->VillageNom=$allocataire->VillageNom;//."-".$allocataire->Ile;
            $res->MontantRessources=$allocataire->MontantRessources;
            $res->QF=($res->IdPADFamille)?$allocataire->QF:0;
            $res->Statut=$allocataire->statut;
            $res->UpdatedAt=$allocataire->UpdatedAt;
            $res->CreatedAt=$allocataire->CreatedAt ;
            $t_results->push($res);
        }
        $t1 = time();
        //dd($t1-$t0);
        $allocataires=$t_results;
        */

        $liste_aides=MyAPP::getListeAides();
        $title="Liste de tous les allocataires";
        $page="";
        if($mode_aff=="light") {
            MyApp::putSessionValue("allocataire_page","_light");
            $page="_light";
            $this->submenu="allocataires_light";
        } else {
            MyApp::putSessionValue("allocataire_page","");
        }
        
        return View::make('tiers.allocataires.index'.$page, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'title' => $title,'ile'=>$ile,'aide'=>$aide,'activite'=>$activite,'page' => $page,
            'allocataires' => $allocataires,'liste_aides' => $liste_aides,
        ]);
    }

    public function index_light($ile="",$aide="",$activite="")
    {
        return $this->index($ile,$aide,$activite,"light");
    }

    public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_AJO")) return redirect('home');

        return $this->create_generic("create","","","");
    }
    
    public function create_generic($mode,$id,$onglet_actif="o_general")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $title="";
        if($onglet_actif=="") $onglet_actif="o_general";
        $allocataire = [];
        $famille = [];
        $titulaire= [];
        $conjoint= [];
        $famille_enfants = [];
        $famille_membres = [];
        $partenaire = [];
        $versements_csr=[];
        $versements=[];
        $montant_fso=[]; //$membres2_fso=[];$montant_fso=0;
        $documents=[];
        $documents_types=[];
        $isTitulaire=false;
        $allocataire_compte="";
        $ressources="";
        $refus="";
        $prime=0;$montant_prime=0;
        if($id) {
            $allocataire = Allocataire::find($id);
            $conjoint=$allocataire->getConjoint();
            if($allocataire->id_famille) {
                $famille=Famille::find($allocataire->id_famille);
                if($famille && ($allocataire->id==$famille->id_titulaire || $allocataire->id==$famille->id_conjoint)) {
                    $famille_enfants = $famille->getEnfants();
                    $famille_membres = $famille->getMembres();
                    $titulaire=$famille->getTitulaire();
                }
                $t_aides=explode(",",$allocataire->types_aides);
                
                if($titulaire && $titulaire->id==$allocataire->id) $isTitulaire=true;
            }
            $allocataire_compte=$allocataire->getLastCompte();

            $versements=Versement::where('id_allocataire','=',$allocataire->id)->orderby('date','asc')->get();
            $refus=VersementRefus::where('id_allocataire','=',$allocataire->id)->orderby('date','asc')->get();
            $ressources = AllocataireRessource::where('id_allocataire','=',$allocataire->id)->orderby('id','desc')->get();
            //Prime Exceptionnelle
            //$montant_prime=MyApp::getPrimeExcept();
            $prime=$allocataire->PrimeAAE;
            $montant_fso=$allocataire->CalculMontantFSO;
            $documents_types=["PASSPORT"=>"Passeport","IDENTITE"=>"Pièce d'indetité"];
            $documents=Document::where("id_allocataire","=",$allocataire->id)->orderby('type','asc')->get();
        }

        $ben_statuts=MyApp::getZBase("BEN_STATUT");
        $ben_statuts_conjugal=MyApp::getZBase("BEN_STATUT_CONJUGAL");
        $ben_statuts_dossier=MyApp::getZBase("BEN_STATUT_DOSSIER");
        $raisons_fso=MyApp::getZBase("BEN_RAISONS_FSO");
        $villages_json=json_encode(MyApp::getVillagesPop());
        $villages_cp_json=json_encode(MyApp::getVillagesCPPop());
        $types_aides_json=json_encode(MyApp::getAidesPop());
        $liste_certificats=MyApp::getZBase("CERT_ENFANTS");
        //$liste_taux_fragilite=MyApp::getTauxFragilitePop();
        $liste_taux_handicap=MyApp::getTauxHandicapPop();
        $liste_niveau_GIR=MyApp::getNiveauGIRPop();

        $page=MyApp::getSessionValue("allocataire_page");
        return View::make('tiers.allocataires.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,
            'page'=>$page,
            'onglet_actif' => $onglet_actif,'title' => $title,
            'ben_statuts' => $ben_statuts,
            'villages_json' => $villages_json,'villages_cp_json'=>$villages_cp_json,
            'types_aides_json' => $types_aides_json,
            'ben_statuts_conjugal' => $ben_statuts_conjugal,
            'ben_statuts_dossier' => $ben_statuts_dossier,
            'allocataire' => $allocataire ,'allocataire_compte' => $allocataire_compte,
            'famille' => $famille ,'isTitulaire' => $isTitulaire,'titulaire' => $titulaire,'conjoint' => $conjoint,
            'famille_enfants' => $famille_enfants ,
            'famille_membres' => $famille_membres ,
            'versements' => $versements,'ressources' => $ressources,'refus' => $refus,
            'liste_certificats' => $liste_certificats ,'liste_taux_handicap' => $liste_taux_handicap,'liste_niveau_GIR' => $liste_niveau_GIR ,
            'prime' => $prime,
            'montant_fso'=>$montant_fso,"raisons_fso" => $raisons_fso,
            'documents_types'=>$documents_types,"documents" => $documents,
            ]);
    }

    public function store(AllocataireRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_AJO")) return redirect('home');

        $allocataire = $this->setData($request);
        //REgarde si reload
        $reload_form=isset($request->reload_form)?$request->reload_form:"";
        if($reload_form) {
            Session::put('onglet_allocataire', $reload_form); 
            return Redirect::to('/allocataires/'.$allocataire->id);
        }
        $page=MyApp::getSessionValue("allocataire_page");
        return Redirect::to('allocataires'.$page);
    }

    public function edit($id,$onglet_actif="o_general")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_MAJ")) return redirect('home');

        return $this->create_generic("edit",$id,$onglet_actif);
    }

    public function update($id,AllocataireRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_MAJ")) return redirect('home');

        $msg="";
        $rib=$request->IBAN_pays.$request->IBAN_cle.$request->IBAN_banque.$request->IBAN_guichet.$request->IBAN_compte.$request->IBAN_clerib;
        if( ($rib!='') && ($request->id_banque=="")) {
            $msg='Vous devez saisir le nom de la banque si vous saisissez le RIB';   
        }
        if(($rib=='') && ($request->id_banque!="")) {
            $msg='Vous devez saisir le RIB (Banque + Guichet + Compte) si vous saisissez le nom de la banque'; 
        }
        if(($rib!='') && ($request->id_banque!="")) {
            $t_compte_champs=MyApp::FORMAT_COMPTE_IBAN;
            foreach($t_compte_champs as $champ=>$size) {
                if(strlen($request->{$champ})!=$size) 
                    $msg.=(($msg!="")?"<br/>":"")."Dans le RIB saisi le champ ".$champ." doit avoir ".$size." caractères";
            } 
        }
        
        if($msg) return redirect()->back()->withInput()->withErrors(['message1'=>$msg]); 

        $allocataire = $this->setData($request,$id);

        //REgarde si reload
        $reload_form=isset($request->reload_form)?$request->reload_form:"";
        if($reload_form) {
            Session::put('onglet_allocataire', $reload_form); 
            return Redirect::to('/allocataires/'.$allocataire->id);
        }
        $url=Session::get('previous_allocataire');
        if($url) return Redirect::to($url);
        $page=MyApp::getSessionValue("allocataire_page");
        return Redirect::to('allocataires'.$page);
    }

    public function show($id,$onglet_actif="o_general")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_VISU")) return redirect('home');
        //Gestion URL
        $previous=URL::previous();
        if(strpos($previous,'edi')===false) //Enregistre previus que si c'était pas le mode edit
            Session::put('previous_allocataire', $previous);
        $onglet_actif=Session::get("onglet_allocataire");
        return $this->create_generic("show",$id,$onglet_actif);
    }

    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_SUP")) return redirect('home');

        $allocataire=Allocataire::find($id);
        $msg=$allocataire->getInfoLien(true);

        if($msg) {
            $msg="Suppression interdite<br/>".$msg;
            Session::flash('message', $msg);
            return Redirect::back()->with('msg', $msg);
        }
         //LOG de la transaction
        $allocataire=Allocataire::find($id);
        $allocataire->log_transaction('','D');

        Allocataire::destroy($id);
        $page=MyApp::getSessionValue("allocataire_page");
        return Redirect::to('allocataires'.$page);
    }

    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $allocataire =  new Allocataire;
        else {
            $allocataire = Allocataire::find($id);
           
        }
        $allocataire->nom  = strtoupper($request->nom);
        $allocataire->nom_naissance  = strtoupper($request->nom_naissance);
        $allocataire->prenom  = $request->prenom;
        $allocataire->id_cpswf  = $request->id_cpswf;
        $allocataire->sexe = $request->sexe;
        $date=$request->date_naissance;
        $allocataire->date_naissance = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $date=$request->date_deces;
        $allocataire->date_deces = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        if($request->statut!="DCD")  $allocataire->date_deces = null;
        else {
            $date=$request->date_deces;
            $allocataire->date_deces = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        }
        $allocataire->lieunaiss = $request->lieunaiss;
        $date=$request->date_arrivee_wf;
        $allocataire->date_arrivee_wf = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $date=$request->date_depart_wf;
        $allocataire->date_depart_wf = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $allocataire->statut_dossier = $request->statut_dossier;
        $allocataire->statut_conjugal = $request->statut_conjugal;
        $allocataire->statut = $request->statut;
        $allocataire->obs = $request->obs;
        $allocataire->adresse = $request->adresse;
        $allocataire->code_postal = $request->code_postal;
        $allocataire->boite_postale  = $request->boite_postale ;
        $allocataire->id_village = $request->id_village;
        $allocataire->mobile = $request->mobile;
        $allocataire->tel = $request->tel;
        $allocataire->email = $request->email;
        $allocataire->verrou = 0;
        $allocataire->controle = $request->controle; 
        $allocataire->save();
        if(($allocataire->Age>21)&&($allocataire->certificat_enfant)) {
            $allocataire->certificat_enfant = null;
        }

        //Sur modification uniquement
        if($id!="") {
            $id_ancien_conjoint=$allocataire->id_conjoint;
            $changement_conjoint=($request->id_conjoint!=$id_ancien_conjoint)?true:false;
            $allocataire->id_parent1 = $request->id_parent1;
            $allocataire->id_parent2 = $request->id_parent2;
            $allocataire->id_conjoint = $request->id_conjoint;
            $allocataire->id_cpswf = $request->id_cpswf;
            $allocataire->types_aides = ((!$request->types_aides) || count($request->types_aides)==0)?null:implode(",",$request->types_aides); 
            $allocataire->quot_fam = $request->quot_fam;
            $allocataire->quot_foy = $request->quot_foy;
            $allocataire->droits_cpswf = $request->droits_cpswf;
            if($user->can("AAE_MAJ")||$user->HasRole('ADMINISTRATEUR')) {
                $allocataire->rappel_aae = $request->rappel_aae; //AAE
                $allocataire->obs_aae = $request->obs_aae; //AAE
                if(isset($request->date_ouverture_aae)) {
                    $date=$request->date_ouverture_aae;
                    $allocataire->date_ouverture_aae = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
                    $date=$request->date_fermeture_aae;
                    $allocataire->date_fermeture_aae = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
                    $allocataire->fermeture_aae_motif = $request->fermeture_aae_motif; 
                }
            }
            if($user->can("PAN_MAJ")||$user->HasRole('ADMINISTRATEUR')) {
                $allocataire->rappel_pan = $request->rappel_pan; //PAN
                $allocataire->obs_pan = $request->obs_pan; //PAN
            }
            if($user->can("CSR_MAJ")||$user->HasRole('ADMINISTRATEUR')) {
                //$allocataire->montant_csr = $request->montant_csr; //CSR Calculé
                $allocataire->rappel_csr = $request->rappel_csr; //CSR
                $allocataire->obs_csr = $request->obs_csr; //CSR
                if(isset($request->date_ouverture_csr)) {
                    $date=$request->date_ouverture_csr;
                    $allocataire->date_ouverture_csr = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
                    $date=$request->date_fermeture_csr;
                    $allocataire->date_fermeture_csr = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
                    $allocataire->fermeture_csr_motif = $request->fermeture_csr_motif; 
                }
                //if(isset($request->montant_retraite)) $allocataire->montant_retraite = $request->montant_retraite;
            }
            if($user->can("FSO_MAJ")||$user->HasRole('ADMINISTRATEUR')) {
                $allocataire->montant_fso = $request->montant_fso; //FSO
                $allocataire->rappel_fso = $request->rappel_fso; //FSO
                $allocataire->raison_fso = $request->raison_fso; //FSO
                $allocataire->obs_fso = $request->obs_fso; //FSO
            }
            if($user->can("APH_MAJ")||$user->HasRole('ADMINISTRATEUR')) {
                $allocataire->tx_handicap_aph = $request->tx_handicap_aph;
                //$allocataire->montant_aph = MyApp::getMontantFragilite($request->tx_fragilite_aph); 
                $allocataire->montant_aph = MyApp::getMontantTauxHandicap($request->tx_handicap_aph); 
                $allocataire->rappel_aph = $request->rappel_aph; 
                //$allocataire->raison_aph = $request->raison_aph; 
                $allocataire->obs_aph = $request->obs_aph; 
            }
            if($user->can("AGD_MAJ")||$user->HasRole('ADMINISTRATEUR')) {
                $allocataire->grp_gir_agd = $request->grp_gir_agd;
                $allocataire->montant_agd = MyApp::getMontantGIR($request->grp_gir_agd);
                $allocataire->rappel_agd = $request->rappel_agd; 
                //$allocataire->raison_agd = $request->raison_agd; 
                $allocataire->obs_agd = $request->obs_agd; 
            }
            $allocataire->procuration_id = $request->procuration_id; 
            $allocataire->procuration_nom = $request->procuration_nom; 
            $allocataire->procuration_prenom = $request->procuration_prenom; 
            $date=$request->procuration_date_naissance;
            $allocataire->procuration_date_naissance = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
            $date=$request->procuration_date_debut;
            $allocataire->procuration_date_debut = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
            $date=$request->procuration_date_fin;
            $allocataire->procuration_date_fin = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
            $allocataire->procuration_motif = $request->procuration_motif; 
            $allocataire->mode_versement = $request->mode_versement; 
            $allocataire->score_fragilite = $request->score_fragilite; 
            $allocataire->save();

            $conjoint=$allocataire->getConjoint();
            //Si conjoint
            if($conjoint) {
                //Si conjoint pas de conjoint on lui met l'allocataire en conjoint
                $conjoint->id_conjoint=$allocataire->id;
                $conjoint->save();
                if(!$allocataire->id_famille) { // Allocataire sans Famille
                   if(!$conjoint->id_famille) { //Conjoint pas de famille non plus on créé la famille
                        $famille=$this->setFamille($allocataire->id,$conjoint->id);
                        $allocataire->id_famille=$famille->id;
                        $allocataire->save();
                        $conjoint->id_famille = $famille->id;
                        $conjoint->save();
                   } else { //Si conjoint à une famille et pas l'allocataire l'allocataire part en famile du conjoint
                        $allocataire->id_famille=($conjoint->id_famille)?$conjoint->id_famille:null;
                        $allocataire->save();
                        //MAJ Famille
                        $famille=Famille::find($conjoint->id_famille);
                        if($famille->id_conjoint==$famille->id_titulaire) {//En cas erreur su famille
                            if($famille->id_titulaire==$allocataire->id) $famille->id_conjoint=$conjoint->id; 
                            else $famille->id_titulaire=$allocataire->id;
                            $famille->save();
                        }
                        $famille->save();
                   }
                } else { //Allocataire avec famille
                    $famille=Famille::find($allocataire->id_famille);
                    if($famille->id_conjoint==$famille->id_titulaire) {//En cas erreur su famille
                        if($famille->id_titulaire==$allocataire->id) $famille->id_conjoint=$conjoint->id; 
                        else $famille->id_titulaire=$allocataire->id;
                        $famille->save();
                    }

                    if(!$conjoint->id_famille) { //Conjoint pas de famille il prend la famille de l'allocataire
                        $conjoint->id_famille = $famille->id;
                        $conjoint->save();
                    } else { //Conjoint avec Famille
                        //Allocataier avec famille te conjoint auss
                        //Si les familles ont différentes on bascule le conjoint dans celle du titulaire

                    }
                    if(!$famille->id_conjoint && $famille->id_titulaire!=$conjoint->id) $famille->id_conjoint=$conjoint->id;
                    else if(!$famille->id_titulaire && $famille->id_conjoint!=$conjoint->id) $famille->id_titulaire=$conjoint->id;
                    $famille->save();
                }
            } 
            //Si pas de conjoint
            if(!$conjoint) { //Si un autre allocataire l'a comme conjoint alors on l'enlève
                $al=Allocataire::where('id_conjoint','',$allocataire->id)->first();
                if($al) {
                    $al->id_conjoint=null;
                    $al->save();
                }
                //Si annulation de l'ancien conjoint => l'ancien conjoint sort de la famille
                if($id_ancien_conjoint) {
                    $ancien_conjoint=Allocataire::find($id_ancien_conjoint);
                    $famille=Famille::find($allocataire->id_famille);
                    //Si l'allocataire est le titulaire => On détache le conjoint
                    if($famille->id_titulaire==$allocataire->id) { 
                        //dd('e');
                        $ancien_conjoint->id_famille=null;
                        $ancien_conjoint->id_conjoint=null;
                        $ancien_conjoint->save();
                        $famille->id_conjoint=null;
                        $famille->save();
                    } 
                    //Si le conjoint est le titulaire => On détache l'allocataire
                    elseif($famille->id_titulaire==$ancien_conjoint->id) { 
                        //dd($famille->id);
                        $allocataire->id_famille=null;
                        $allocataire->id_conjoint=null;
                        $allocataire->save();
                        $famille->id_conjoint=null;
                        $famille->save();
                    }
                }
            }

        }
        //LOG de la transaction
        $allocataire->log_transaction($request->url(),'U');

        //MAJ Compte bancaire
        $allocataire_compte=$this->setBanque($request,$allocataire,$user,$id);

        return $allocataire;
    }

    // BANQUE
    public function setBanque($request,$allocataire,$user,$id="")
    {
        /* *** Gestion du RIB juste sur modification *** */
        $change="";
        $allocataire_compte="";
        $t_compte_champs=MyApp::COMPTE_IBAN;
        if($id!="") {
            $allocataire_compte=$allocataire->getLastCompte();
            if($allocataire_compte) {
                if($allocataire_compte->id_banque=($request->id_banque)) $change.="1";
                foreach($t_compte_champs as $champ) {
                    if($allocataire_compte->{$champ}!=($request->{$champ})) $change.="1";
                    else $change.="0";
                }
                $change="0".$change;
                $change = dechex(bindec($change));
            }
            if( intVal($change)!=0) { //Si il y a eu un changement
                //On desactive le compte en cours
                $allocataire_compte->actif='0';
                $allocataire_compte->save();
                $allocataire_compte->log_transaction($request->url(),'U',"desactive");
            }
        }

        /* *** Enregistrement *** */
        //SI changement ou pas de banque
        if( (hexdec($change)!=0) || ($change=="")) { 
            $do_save=true;
            //création du nouveau compte
            if($change=="") $change="00";

            $allocataire_compte = new AllocataireCompte;
            foreach($t_compte_champs as $champ) $allocataire_compte->{$champ} = $request->{$champ};
            $allocataire_compte->id_allocataire=$allocataire->id;
            $allocataire_compte->id_banque=$request->id_banque;
            $allocataire_compte->infomodif=$change;
            $allocataire_compte->actif='1';
            $allocataire_compte->id_user=$user->id;
            $allocataire_compte->date=date('Y-m-j h:i:s');
            if(($change=="00")&&($allocataire_compte->id_banque==null)) $do_save=false; //Si banque pas saisie en creation on ne sauve pas
            if($do_save) {
                $allocataire_compte->save();
                $allocataire_compte->log_transaction($request->url(),'I');
            }
        }
        return $allocataire_compte;
    }

    // AIDANT
    public function setDataAidant($request,$id="")
    {
        if($id=="") $allocataires_aidants =  new AllocataireAidant;
        else $allocataires_aidants = AllocataireAidant::find($id);
        $allocataires_aidants->aidant_type_aide = $request->aidant_type_aide;
        $allocataires_aidants->aidant_sante = $request->aidant_sante;
        $allocataires_aidants->aidant_ressenti = $request->aidant_ressenti;
        $allocataires_aidants->aidant_relais = $request->aidant_relais;
        $allocataires_aidants->aidant_relais_desc = $request->aidant_relais_desc;
        $allocataires_aidants->save();
        return $allocataires_aidants;
    }

    public function setFamille($id_titulaire,$id_conjoint="") {
        $famille =  new Famille;
        $famille->id_titulaire=$id_titulaire;
        $famille->id_conjoint=($id_conjoint)?$id_conjoint:null;
        $famille->save();
        return $famille;
    }

    public function add_enfant(Request $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_MAJ")) return redirect('home');

        
        //Parent
        $id_allocataire_parent=$request->id_allocataire;
        $parent=Allocataire::find($id_allocataire_parent);
        //enfant
        $id_enfant=$request->id_enfant;
        $enfant=Allocataire::find($id_enfant);
        $nom_enfant=$enfant->NomComplet;

        $msg="";
        $id_famille=($parent->id_famille)?$parent->id_famille:null;
        if(!$id_famille) {
            $famille=$this->setFamille($parent->id,$parent->id_conjoint);
            $parent->id_famille=$famille->id; //
            $parent->save();
        } else {
            $famille=Famille::find($id_famille);
        }
        $famille_enfant=FamilleEnfant::where("id_enfant","=",$id_enfant)->first();
        $change=true;
        if(!$famille_enfant) {
            $famille_enfant=new FamilleEnfant;
            $famille_enfant->id_enfant=$id_enfant;
            $change=false;
        }
        $famille_enfant->id_famille=$famille->id;
        $famille_enfant->lien_parente="ENF";
        $famille_enfant->save();
        //Change Famille de l'enfant
        
        $msg="<blockquote><h2>La fiche de l'enfant <strong>".$enfant->NomComplet."</strong> a été ".((!$change)?"modifiée.":"changée de famille")."</h2></blockquote>";
        Session::put("onglet_allocataire","o_foyer");
        Session::flash('message', $msg);
        return Redirect::back();
    }

    public function add_membre(Request $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("ALO_MAJ")) return redirect('home');

        //Parent
        $id_allocataire=$request->id_allocataire;
        $allocataire=Allocataire::find($id_allocataire);
        //Membre
        $id_membre=$request->id_membre;
        $membre=Allocataire::find($id_membre);
        $nom_membre=$membre->NomComplet;

        $msg="";
        $id_famille=$allocataire->id_famille;
        if(!$id_famille) {
            $famille=$this->setFamille($allocataire->id,"");
            $allocataire->id_famille=$famille->id; //
            $allocataire->save();
        } else {
            $famille=Famille::find($id_famille);
        }
        $famille_membre=FamilleMembre::where("id_membre","=",$id_membre)->first();
        $change=true;
        if(!$famille_membre) {
            $famille_membre=new FamilleMembre;
            $famille_membre->id_membre=$id_membre;
            $change=false;
        }
        $famille_membre->id_famille=$famille->id;
        $famille_membre->lien_parente="";
        $famille_membre->save();
        $msg="<blockquote><h2>La fiche du membre  <strong>".$membre->NomComplet."</strong> a été ".((!$change)?"modifiée.":"changée de famille")."</h2></blockquote>";
        Session::put("onglet_allocataire","o_foyer");
        Session::flash('message', $msg);
        return Redirect::back();
    }

    public function autocomplete_conjoint(AllocataireAutoRequest $request)
    { 
        $param = $request->term;
        $associate = array();
        $sql="select id ,";
        $sql.=" CONCAT(";
        $sql.=" TRIM(nom_naissance) ,'  ',TRIM(prenom),'  (',DATE_FORMAT(date_naissance, '%d/%m/%Y'),') id:',id  ";
        $sql.=" ) as value  ";
        $sql.=" from allocataires ";
        $sql.=" where ";
        $sql.=" (nom_naissance like '{$param}%') ";
        $sql.=" or (CONCAT(TRIM(nom_naissance) ,' ',TRIM(prenom)) like '{$param}%') ";
        //$sql.=" or (CONCAT(TRIM(nom) ,' ',TRIM(prenom)) like '{$param}%') ";
        $sql.=" or (id='{$param}') ";
        $sql.=" or (prenom like '%{$param}%') ";
        $sql.=" ; ";

        $search    = DB::select($sql);
        foreach ($search as $result) {
            $associate[] = $result;
        }
        $associate[]=["id"=>'',"value"=>'Aucun'];
        return json_encode($associate);
    }

    public function autocomplete_parent(AllocataireAutoRequest $request)
    { 
        $param = $request->term;
        $associate = array();
        $sql="select id ,";
        $sql.=" CONCAT(";
        $sql.=" TRIM(nom_naissance) ,'  ',TRIM(prenom),'  (',DATE_FORMAT(date_naissance, '%d/%m/%Y'),') id:',id  ";
        $sql.=" ) as value  ";
        $sql.=" from allocataires ";
        $sql.=" where ";
        $sql.=" (nom_naissance like '{$param}%') ";
        $sql.=" or (CONCAT(TRIM(nom_naissance) ,' ',TRIM(prenom)) like '{$param}%') ";
        //$sql.=" or (CONCAT(TRIM(nom) ,' ',TRIM(prenom)) like '{$param}%') ";
        $sql.=" or (id='{$param}') ";
        $sql.=" or (prenom like '%{$param}%') ";
        $sql.=" ; ";

        $search    = DB::select($sql);
        foreach ($search as $result) {
            $associate[] = $result;
        }
        $associate[]=["id"=>'',"value"=>'Aucun'];
        return json_encode($associate);
    }

    public function autocomplete_enfant(AllocataireAutoRequest $request)
    { 
        $param = $request->term;
        $associate = array();
        $sql="select id ,";
        $sql.=" CONCAT(";
        $sql.=" TRIM(nom_naissance) ,'  ',TRIM(prenom),'  (',DATE_FORMAT(date_naissance, '%d/%m/%Y'),') id:',id  ";
        $sql.=" ) as value  ";
        $sql.=" from allocataires ";
        $sql.=" where ";
        $sql.=" (nom_naissance like '{$param}%') ";
        $sql.=" or (CONCAT(TRIM(nom_naissance) ,' ',TRIM(prenom)) like '{$param}%') ";
        //$sql.=" or (CONCAT(TRIM(nom) ,' ',TRIM(prenom)) like '{$param}%') ";
        $sql.=" or (id='{$param}') ";
        $sql.=" or (prenom like '%{$param}%') ";
        $sql.=" ; ";

        $search    = DB::select($sql);
        foreach ($search as $result) {
            $associate[] = $result;
        }
        $associate[]=["id"=>'',"value"=>'Aucun'];
        return json_encode($associate);
    }

    public function autocomplete_membre(AllocataireAutoRequest $request)
    { 
        $param = $request->term;
        $associate = array();

        $sql="select id ,";
        $sql.=" CONCAT(";
        $sql.=" TRIM(nom_naissance) ,'  ',TRIM(prenom),'  (',DATE_FORMAT(date_naissance, '%d/%m/%Y'),') id:',id  ";
        $sql.=" ) as value  ";
        $sql.=" from allocataires ";
        $sql.=" where ";
        $sql.=" (nom_naissance like '{$param}%') ";
        $sql.=" or (CONCAT(TRIM(nom_naissance) ,' ',TRIM(prenom)) like '{$param}%') ";
        //$sql.=" or (CONCAT(TRIM(nom) ,' ',TRIM(prenom)) like '{$param}%') ";
        $sql.=" or (id='{$param}') ";
        $sql.=" or (prenom like '%{$param}%') ";
        $sql.=" ; ";

        $search    = DB::select($sql);

        foreach ($search as $result) {
            $associate[] = $result;
        }
        $associate[]=["id"=>'',"value"=>'Aucun'];
        return json_encode($associate);
    }

    public function autocomplete_procuration(AllocataireAutoRequest $request)
    { 
        $param = $request->term;
        $associate = array();
        $sql="select id ,nom_naissance as nom,";
        $sql.=" CONCAT(";
        $sql.=" TRIM(nom_naissance),' ; ',TRIM(prenom),' ; ',DATE_FORMAT(date_naissance, '%d/%m/%Y'),' ; ',id";
        $sql.=" ) as value  ";
        $sql.=" from allocataires ";
        $sql.=" where ";
        $sql.=" (nom_naissance like '{$param}%') ";
        $sql.=" or (CONCAT(TRIM(nom_naissance) ,' ',TRIM(prenom)) like '{$param}%') ";
        //$sql.=" or (CONCAT(TRIM(nom) ,' ',TRIM(prenom)) like '{$param}%') ";
        $sql.=" or (id='{$param}') ";
        $sql.=" or (prenom like '%{$param}%') ";
        $sql.=" ; ";

        $search    = DB::select($sql);
        foreach ($search as $result) {
            $associate[] = $result;
        }
        return json_encode($associate);
    }

    public function autocomplete_home(AllocataireAutoRequest $request)
    { 
        $param = $request->term;
        $associate = array();
        $mode="";

        if(substr($param,0,1)=="*") {
            $param=substr($param,1);
            $sql="SELECT a.id_famille id, 'F' mode,";
            $sql.="CONCAT(a.id_famille,' ',a.nom_naissance,' ',a.prenom) as value, ";
            $sql.="FROM familles ";
            $sql.="left outer join allocataires a on a.id=familles.id_titulaire ";
            $sql.="WHERE a.nom_naissance like '{$param}%' or familles.id like '{$param}%' ";
            $sql.=" or CONCAT(TRIM(a.nom_naissance) ,' ',TRIM(a.prenom)) like '{$param}%' ";
            $sql.=" or (a.id_famille='{$param}') ";
            $sql.=" ; ";
            $mode="F";
        } else {
            $sql="select id ,";
            $sql.=" CONCAT(";
            $sql.=" TRIM(nom_naissance) ,'  ',TRIM(prenom),'  (',DATE_FORMAT(date_naissance, '%d/%m/%Y'),') id:',id  ";
            $sql.=" ) as value  ";
            //$sql.="ae.id as ae_id ";
            $sql.=" FROM allocataires ";
            //$sql.="left outer join familles_enfants ON familles_enfants.id_enfant=10 ";
            $sql.=" where ";
            $sql.=" (nom_naissance like '{$param}%') ";
            $sql.=" or (CONCAT(TRIM(nom_naissance) ,' ',TRIM(prenom)) like '{$param}%') ";
            //$sql.=" or (CONCAT(TRIM(nom) ,' ',TRIM(prenom)) like '{$param}%') ";
            $sql.=" or (id='{$param}') ";
            $sql.=" or (prenom like '%{$param}%') ";
            $sql.=" ; ";
        }
        $search    = DB::select($sql);

        foreach ($search as $result) {
            $associate[] = $result;
        }
        //$associate[] =$sql;
        $associate[]=["id"=>'',"value"=>'Aucun',"mode"=>$mode];
        return json_encode($associate);

    }
}

