<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;

use App\Models\Allocataire;
use App\Models\AllocataireMembre;
use App\Models\User;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use App\Http\Controllers\Logs;


class AllocatairesMembresController extends Controller {

    private $menu='allocataires';
    private $submenu='enfants';
    private $menu_home="aides";


    public function index()
    {

    }

    public function create($allocataire_id,$mode="create",$mode_frame=false) {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(($mode=="create") && !$user->can("ALO_MAJ")) return redirect('home');

        $page=($mode_frame)?$mode."_pop":$mode;
        $allocataire=Allocataire::find($allocataire_id);
        return View::make('tiers.membres.'.$page, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'mode' => $mode,
            'allocataire' => $allocataire
        ]);
    }

    public function create_pop($allocataire_id,$mode="create") {
        return $this->create($allocataire_id,$mode="create",true);
    }


    public function store(EnfantRequest $request)
    {

    }

    public function edit($id,$allocataire_id="",$mode="edit")
    {

    }

    public function update($id,EnfantRequest $request)
    {

    }

    public function show($id,$id_allocataire="")
    {

    }

    public function destroy($id_membre,$id_parent,$type="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->HasRole('ADMINISTRATEUR')) if(!$user->can("FAM_MAJ")) return redirect('home');

        $allocataires_membres=AllocataireMembre::where('id_parent1','=',$id_parent)->orWhere('id_parent2','=',$id_parent)->get();
        foreach($allocataires_enfants as $allocataire_enfant) {
            if(($allocataire_enfant->id_parent1==$id_parent) || ($allocataire_enfant->id_parent2==$id_parent)) {
                if($allocataire_enfant->id==$id_enfant) $allocataire_enfant->delete();
                $msg="Le  "." a été enlevé do foyer ";;
            }
        }

        if($msg) Session::flash('message', $msg);
        Session::put('onglet_allocataire', "o_foyer");
        return Redirect::to('/allocataire_show/'.$id_parent."/".$type);
    }

    public function setData($request,$id="")
    {
        if($id) $enfant = Enfant::find($id);
        else $enfant = new Enfant;
        $enfant->nom  = strtoupper($request->nom);
        $enfant->prenom  = ($request->prenom);
        $enfant->sexe = $request->sexe;
        $date=$request->date_naissance;
        $enfant->date_naissance = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $enfant->certif = $request->certif;
        $enfant->parents1 = $request->id_allocataire;
        $enfant->parents2 = null;
        $enfant->obs = $request->obs;
        $enfant->save();
        return $enfant;
    }


    public function autocomplete_enfant(AllocataireAutoRequest $request)
    { 
        $param = $request->term;
        $associate = array();
        $search    = DB::select(
            "select id ,CONCAT(TRIM(nom) ,'  ',TRIM(prenom),'  (',DATE_FORMAT(date_naissance, '%d/%m/%Y'),')'
                ) as value from allocataires where nom like ('{$param}%') or id='{$param}%'
            "
        );
        foreach ($search as $result) {
            $associate[] = $result;
        }
        $associate[]=["id"=>'',"value"=>'Aucun'];
        return json_encode($associate);
    }

}
