<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\AllocataireRessource;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use App\Http\Requests\AllocataireRessourceRequest;
use App\Http\Requests\AllocataireAutoRequest;
use View;
use DB;

class AllocatairesRessourcesController extends Controller {

    private $menu_home='base';
    private $menu='dossiers';
    private $submenu='ressources';

    public function index()
    {
       if(!($user=Auth::user())) return Redirect::route( 'login' );
       if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("RES_VISU")) return redirect('home');
        $ressources = AllocataireRessource::all();

        return View::make('ressources.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'ressources'=>$ressources
        ]);
    }
 
    public function create($allocataire_id="",$mode_frame=false) {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("RES_AJO")) return redirect('home');

        $mode="create";
        $types_ressources=MyApp::getZBase("BEN_RESSOURCE");
        
        return View::make('ressources.create', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode"=>$mode,
            "types_ressources" => $types_ressources,"mode_frame" => $mode_frame,
            "allocataire_id"=>$allocataire_id
        ]);
    }

    
    public function create_pop($allocataire_id,$mode="create") {
        return $this->create($allocataire_id,true);
    }

    public function store(AllocataireRessourceRequest $request)
    {
        $ressource = $this->setData($request);
        if($request->mode_frame) {
            Session::put("onglet_allocataire","o_ressources");
            Session::flash('close_pop', "Ressource ajoutée");
            return Redirect::to('allocataires_add_ressources_pop/'.$request->id_allocataire);
        }
        $msg="Le Ressource ".$ressource->nom." a été créée";
        Session::flash('message', $msg);
        return Redirect::to('ressources');
    }
 

    public function edit($id,$mode="edit",$mode_frame=false)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if($mode=="edit") if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("RES_MAJ")) return redirect('home');
        else if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("RES_VISU")) return redirect('home');

        $ressource = AllocataireRessource::find($id);

        $types_ressources=MyApp::getZBase("BEN_RESSOURCE");
        return View::make('ressources.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode"=>$mode,
            "mode_frame"=>$mode_frame,
            "ressource" => $ressource,"types_ressources" => $types_ressources
        ]);
    }
 
    public function edit_pop($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        return $this->edit($id,"edit",'true');
    }

    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        return $this->edit($id,"show");
    }

    public function show_pop($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        return $this->edit($id,"show",'true');
    }

    public function update($id,AllocataireRessourceRequest $request)
    {
        $ressource = $this->setData($request,$id);
        if($request->mode_frame) {
            Session::put("onglet_allocataire","o_ressources");
            Session::flash('close_pop', "Ressource modifiée");
            return Redirect::to('allocataires_add_ressources_pop/'.$request->id_allocataire);
        }
        $msg="Le Ressource ".$ressource->nom." a été mise à jour";
        Session::flash('message', $msg);
        return Redirect::to('ressources');
    }
 
    public function delete_pop($id)
    {
        $ressource = AllocataireRessource::find($id);
        return $this->destroy($id,$ressource->id_allocataire);
    }

    public function destroy($id,$id_allocataire="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("RES_SUP")) return redirect('home');

        AllocataireRessource::destroy($id);
        if($id_allocataire) {
            Session::put("onglet_allocataire","o_ressources");
            Session::flash('close_pop', "close");
            return Redirect::to('allocataires_add_ressources_pop/'.$id_allocataire);
        }
        return Redirect::to('ressources');
    }
 
    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $ressource =  new AllocataireRessource;
        else $ressource = AllocataireRessource::find($id);
        
        $ressource->id_allocataire  = $request->id_allocataire;
        $ressource->type_ressource  = $request->type_ressource;
        $ressource->montant   = $request->montant; 
        $ressource->source   = $request->source; 
        $ressource->montant   = $request->montant; 
        $ressource->observations   = $request->observations; 
        $date=$request->date_fin;
        $ressource->date_fin = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $ressource->save();

        return $ressource;
    }


    public function autocomplete_allocataire(AllocataireAutoRequest $request)
    { 
        //$associate[]=["id"=>'AAA',"value"=>'Aucun'];
        //return json_encode($associate);
        $param = $request->term;
        $associate = array();
        $sql="select id ,";
        $sql.=" CONCAT(";
        $sql.=" TRIM(nom_naissance) ,'  ',TRIM(prenom),'  (',DATE_FORMAT(date_naissance, '%d/%m/%Y'),') id:',id  ";
        $sql.=" ) as value  ";
        $sql.=" from allocataires ";
        $sql.=" where ";
        $sql.=" (nom_naissance like '{$param}%') ";
        $sql.=" or (CONCAT(TRIM(nom_naissance) ,' ',TRIM(prenom)) like '{$param}%') ";
        //$sql.=" or (CONCAT(TRIM(nom) ,' ',TRIM(prenom)) like '{$param}%') ";
        $sql.=" or (id='{$param}') ";
        $sql.=" or (prenom like '%{$param}%') ";
        $sql.=" ; ";
        $search    = DB::select($sql);

        foreach ($search as $result) {
            $associate[] = $result;
        }
        $associate[]=["id"=>'',"value"=>'Aucun'];
        return json_encode($associate);
    }
}